/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.vie;

import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.formplugin.vie.ISrcVieAgainConfirmHandler;

public class SrcVieAgainConfirmRegionHandler
implements ISrcVieAgainConfirmHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(DynamicObject billObj) {
        this.updatePurlistVieRegion(billObj);
    }

    private void updatePurlistVieRegion(DynamicObject billObj) {
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        if (null == rows || rows.size() == 0) {
            return;
        }
        Map<Object, DynamicObject> valueMap = rows.stream().collect(Collectors.groupingBy(e -> e.getLong("purlist.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        long projectId = billObj.getLong("project.id");
        String turns = billObj.getString("turns");
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("turns", "=", (Object)turns);
        qfilter.and("purlist", "in", valueMap.keySet());
        qfilter.and("supplier", ">", (Object)0L);
        DynamicObject[] purlistObjs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)"purlist.id,viefrom,vieto", (QFilter[])qfilter.toArray());
        if (purlistObjs.length == 0) {
            return;
        }
        for (DynamicObject purlistObj : purlistObjs) {
            long purlistId = purlistObj.getLong("purlist.id");
            DynamicObject valueObj = valueMap.get(purlistId);
            if (null == valueObj) continue;
            purlistObj.set("viefrom", valueObj.get("viefrom"));
            purlistObj.set("vieto", valueObj.get("vieto"));
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])purlistObjs);
    }
}

