/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.vie;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.enums.SrcVieStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.src.formplugin.vie.ISrcVieAgainConfirmHandler;

public class SrcVieAgainConfirmTurnsHandler
implements ISrcVieAgainConfirmHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(DynamicObject billObj) {
        long entryId = PdsCommonUtils.object2Long((Object)billObj.get("entryid"));
        long projectId = billObj.getLong("project.id");
        DynamicObject competeBillObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_competebill");
        DynamicObjectCollection turnsObjs = competeBillObj.getDynamicObjectCollection("entryentityturns");
        if ("2".equals(billObj.getString("vieturns")) && entryId == 0L) {
            this.createFirstTurns(turnsObjs, competeBillObj);
        }
        this.updateCompeteBill(competeBillObj, billObj);
        if (!"1".equals(billObj.getString("vieturns"))) {
            DynamicObject turnsObj = this.getOrCreateTurnsObj(billObj, turnsObjs, entryId);
            this.updateCurrentTurns(turnsObj, billObj, competeBillObj);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject)competeBillObj);
    }

    private void updateCompeteBill(DynamicObject competeBillObj, DynamicObject billObj) {
        this.updateOtherVieRules(billObj, competeBillObj, "");
        competeBillObj.set("opendate", (Object)billObj.getDate("turnsopendate"));
        competeBillObj.set("planopendate", (Object)billObj.getDate("turnsopendate"));
        competeBillObj.set("bidtime", (Object)billObj.getInt("turnsbidtime"));
        competeBillObj.set("bidstatus", (Object)billObj.getString("turnsbidstatus"));
        competeBillObj.set("pausetime", null);
        competeBillObj.set("bidrestoftime", null);
        competeBillObj.set("pauseamt", null);
        competeBillObj.set("pausestarttime", null);
        competeBillObj.set("addtimecount", (Object)0);
        competeBillObj.set("addtime", null);
        competeBillObj.set("lastquotedate", null);
    }

    private void createFirstTurns(DynamicObjectCollection turnsObjs, DynamicObject competeBillObj) {
        DynamicObject firstTurnsObj = turnsObjs.addNew();
        PdsCommonUtils.setPrimaryKey((DynamicObject)firstTurnsObj);
        this.updateOtherVieRules(competeBillObj, firstTurnsObj, "turns");
        firstTurnsObj.set("seq", (Object)1);
        firstTurnsObj.set("turns", (Object)"1");
        firstTurnsObj.set("vieturns", (Object)"1");
        firstTurnsObj.set("turnsopendate", (Object)competeBillObj.getDate("opendate"));
        firstTurnsObj.set("turnsbidtime", (Object)competeBillObj.getInt("bidtime"));
        firstTurnsObj.set("turnsbidstatus", (Object)SrcVieStatusEnums.CONFIRMED.getValue());
    }

    private void updatePreviousTurns(DynamicObjectCollection turnsObjs, DynamicObject billObj) {
        int currentTurn = billObj.getInt("vieturns");
        List rows = turnsObjs.stream().filter(e -> e.getInt("vieturns") < currentTurn && !e.getString("turnsbidstatus").equals(SrcVieStatusEnums.CONFIRMED.getValue())).collect(Collectors.toList());
        if (rows.size() > 0) {
            for (DynamicObject row : rows) {
                row.set("turnsbidstatus", (Object)SrcVieStatusEnums.CONFIRMED.getValue());
            }
        }
    }

    private void updateCurrentTurns(DynamicObject turnsObj, DynamicObject billObj, DynamicObject competeBillObj) {
        if (null == turnsObj) {
            return;
        }
        this.updateOtherVieRules(competeBillObj, turnsObj, "turns");
        turnsObj.set("vieturns", (Object)billObj.getString("vieturns"));
        turnsObj.set("turnsopendate", (Object)billObj.getDate("turnsopendate"));
        turnsObj.set("turnsbidtime", (Object)billObj.getInt("turnsbidtime"));
        turnsObj.set("turnsbidstatus", (Object)billObj.getString("turnsbidstatus"));
        turnsObj.set("turns", (Object)PdsVieHelper.getLastNegTurns((DynamicObject)PdsVieHelper.getLastNegTurnsObj((long)billObj.getLong("project.id"))));
    }

    private DynamicObject getOrCreateTurnsObj(DynamicObject billObj, DynamicObjectCollection turnsObjs, long entryId) {
        DynamicObject turnsObj = null;
        if (entryId == 0L) {
            if (!"2".equals(billObj.getString("vieturns"))) {
                this.updatePreviousTurns(turnsObjs, billObj);
            }
            turnsObj = turnsObjs.addNew();
            PdsCommonUtils.setPrimaryKey((DynamicObject)turnsObj);
            turnsObj.set("seq", (Object)turnsObjs.size());
        } else {
            for (DynamicObject obj : turnsObjs) {
                if (PdsCommonUtils.object2Long((Object)obj.getPkValue()) != entryId) continue;
                turnsObj = obj;
                break;
            }
        }
        return turnsObj;
    }

    public void updateOtherVieRules(DynamicObject sourceObj, DynamicObject targetObj, String prefix) {
        List<String> properties = this.getProperties(sourceObj, targetObj);
        PdsCommonUtils.copyDynamicObjectValue((DynamicObject)sourceObj, (DynamicObject)targetObj, properties, Collections.emptySet(), (int)-1, (String)"", (String)prefix);
    }

    private List<String> getProperties(DynamicObject sourceObj, DynamicObject targetObj) {
        List<String> properties = this.getProperties(sourceObj);
        List<String> properties2 = this.getProperties(targetObj);
        return PdsCommonUtils.getIntersectList(properties, properties2);
    }

    private List<String> getProperties(DynamicObject billObj) {
        List properties = null;
        properties = "src_vie_again".equals(billObj.getDataEntityType().getName()) || "src_vie_again_region".equals(billObj.getDataEntityType().getName()) ? DynamicObjectUtil.getEntryentityProperties((IDataEntityType)billObj.getDataEntityType()) : DynamicObjectUtil.getDynamicAllProperties((DynamicObject)billObj);
        properties.remove("seq");
        properties.remove("turns");
        properties.remove("vieturns");
        properties.remove("turnsopendate");
        properties.remove("turnsbidtime");
        properties.remove("turnsbidstatus");
        return properties.stream().map(e -> e.replace("turns", "")).collect(Collectors.toList());
    }
}

