/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.vie;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.enums.VieTurnsEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.vie.PdsVieHelper;

public class SrcVieStartPlugin
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setProjectId();
        this.setVieTurns();
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (evt.getOperateKey().equals("confirm")) {
            PdsCommonUtils.refreshParentView((IFormView)this.getView());
            this.getView().close();
        }
    }

    private void setProjectId() {
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        long projectId = PdsCommonUtils.object2Long(paramMap.get("billid"));
        this.getModel().setValue("project", (Object)projectId);
    }

    private void setVieTurns() {
        DynamicObject projectObj = this.getModel().getDataEntity().getDynamicObject("project");
        if (null == projectObj) {
            return;
        }
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)projectObj);
        HashMap<String, Object> turnsMap = new HashMap<String, Object>(4);
        DynamicObject competeBillObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_competebill");
        turnsMap.put("turnsopendate", competeBillObj.getDate("planopendate"));
        turnsMap.put("turnsbidtime", competeBillObj.getInt("bidtime"));
        turnsMap.put("turnsbidstatus", competeBillObj.getString("bidstatus"));
        DynamicObject vieTurnsObj = PdsVieHelper.getLastVieTurnsObj((DynamicObject)competeBillObj, null);
        if (null != vieTurnsObj) {
            turnsMap.put("turns", vieTurnsObj.getString("turns"));
            turnsMap.put("vieturns", vieTurnsObj.getString("vieturns"));
        } else {
            String negTurns = PdsVieHelper.getLastNegTurns((DynamicObject)PdsVieHelper.getLastNegTurnsObj((long)SrmCommonUtil.getPkValue((DynamicObject)competeBillObj)));
            if (null != negTurns && !"0".equals(negTurns)) {
                turnsMap.put("turns", negTurns);
            } else {
                turnsMap.put("turns", QuoteTurnsEnums.NEGOTIATE00.getValue());
            }
            turnsMap.put("vieturns", VieTurnsEnums.VIE01.getValue());
        }
        this.setTurnsInfo(turnsMap);
    }

    private void setTurnsInfo(Map<String, Object> turnsMap) {
        this.getModel().setValue("entryid", turnsMap.get("entryid"));
        this.getModel().setValue("turns", turnsMap.get("turns"));
        this.getModel().setValue("vieturns", turnsMap.get("vieturns"));
        this.getModel().setValue("turnsopendate", turnsMap.get("turnsopendate"));
        this.getModel().setValue("turnsbidtime", turnsMap.get("turnsbidtime"));
        this.getModel().setValue("turnsbidstatus", turnsMap.get("turnsbidstatus"));
    }
}

