/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.vie;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.entity.PdsObjectPools;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.enums.SrcNegotiatetypeEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.pds.common.util.SrcCompeteUtils;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.src.common.vie.SrcVieRestoftimeOutOpenVieHall;
import kd.scm.src.formplugin.vie.ISrcBidStartVerifier;
import kd.scm.src.formplugin.vie.ISrcVieOperateStatus;
import kd.scm.src.formplugin.vie.SrcVieOperateStatusContext;
import kd.scm.src.formplugin.vie.SrcVieOperateStatusStand;

public class SrcVieUtils {
    public static SrcVieOperateStatusContext getContextInstance() {
        return (SrcVieOperateStatusContext)ExtPluginFactory.getInstance().getExtPluginInstance(SrcVieOperateStatusContext.class.getSimpleName(), SrcVieOperateStatusContext.class.getName());
    }

    public static void getListVieOperateStatus(SrcVieOperateStatusContext context) {
        ISrcVieOperateStatus vieStatus = (ISrcVieOperateStatus)ExtPluginFactory.getInstance().getExtPluginInstance(ISrcVieOperateStatus.class.getSimpleName());
        if (null == vieStatus) {
            vieStatus = new SrcVieOperateStatusStand();
        }
        vieStatus.getListVieOperateStatus(context);
    }

    public static void getEditVieOperateStatus(SrcVieOperateStatusContext context) {
        ISrcVieOperateStatus vieStatus = (ISrcVieOperateStatus)ExtPluginFactory.getInstance().getExtPluginInstance(ISrcVieOperateStatus.class.getSimpleName());
        if (null == vieStatus) {
            vieStatus = new SrcVieOperateStatusStand();
        }
        vieStatus.getEditVieOperateStatus(context);
    }

    public static void setVieOperateVisible(IFormView view) {
        SrcVieOperateStatusContext context = SrcVieUtils.getContextInstance();
        context.setView(view);
        SrcVieUtils.setVieOperateStatusContext(context);
        SrcVieUtils.getEditVieOperateStatus(context);
        view.setVisible(Boolean.valueOf(context.isVieAgain()), new String[]{"bar_vieagain"});
        view.setVisible(Boolean.valueOf(context.isBidStart()), new String[]{"bar_bidstart"});
        view.setVisible(Boolean.valueOf(context.isVieHall()), new String[]{"bar_viehall"});
    }

    private static SrcVieOperateStatusContext setVieOperateStatusContext(SrcVieOperateStatusContext context) {
        if ("src_negotiatebill".equals(context.getView().getEntityId())) {
            context.setBillId(SrmCommonUtil.getPkValue((DynamicObject)context.getView().getModel().getDataEntity()));
            context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)context.getView().getModel().getDataEntity().getDynamicObject("project")));
            context.setBillStatus(context.getView().getModel().getDataEntity().getString("billstatus"));
            context.setBizStatus(context.getView().getModel().getDataEntity().getString("bizstatus"));
            context.setBidStatus(context.getView().getModel().getDataEntity().getString("project.bidstatus"));
            context.setSourceType(context.getView().getModel().getDataEntity().getString("project.sourcetype.number"));
            context.setSrctypeId(context.getView().getModel().getDataEntity().getLong("project.srctype.id"));
            context.setNegotiateType(context.getView().getModel().getDataEntity().getString("negotiatetype"));
        } else {
            context.setBillId(SrmCommonUtil.getPkValue((DynamicObject)context.getView().getModel().getDataEntity()));
            context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)context.getView().getModel().getDataEntity()));
            context.setBillStatus(context.getView().getModel().getDataEntity().getString("billstatus"));
            context.setBizStatus(context.getView().getModel().getDataEntity().getString("bizstatus"));
            context.setBidStatus(context.getView().getModel().getDataEntity().getString("bidstatus"));
            context.setSourceType(context.getView().getModel().getDataEntity().getString("sourcetype.number"));
            context.setSrctypeId(context.getView().getModel().getDataEntity().getLong("srctype.id"));
            context.setNegotiateType(SrcNegotiatetypeEnums.ONLINE_VIE.getValue());
        }
        return context;
    }

    public static void vieOperateHandle(IFormView view, BeforeItemClickEvent evt, long billId, CloseCallBack closeCallBack) {
        Map paraMap;
        String opkey = evt.getItemKey();
        ArrayList<String> opkeys = new ArrayList<String>(6);
        opkeys.add("tblvieagain");
        opkeys.add("tblbidstart");
        opkeys.add("tblviehall");
        opkeys.add("bar_vieagain");
        opkeys.add("bar_bidstart");
        opkeys.add("bar_viehall");
        opkeys.add("tblvieanalyse");
        opkeys.add("bar_vieanalyse");
        if (!opkeys.contains(opkey)) {
            return;
        }
        long projectId = billId;
        if ("src_negotiatebill".equals(view.getEntityId())) {
            projectId = SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity().getDynamicObject("project"));
        }
        if (!((Boolean)(paraMap = SrcCompeteUtils.getValidProjectId((long)projectId)).get("succed")).booleanValue()) {
            view.showTipNotification(paraMap.get("message").toString());
            evt.setCancel(true);
            return;
        }
        paraMap.put("srcbillid", billId);
        SrcVieOperateStatusContext context = SrcVieUtils.getContextInstance();
        context.setView(view);
        context.setOpKey(evt.getItemKey());
        context.setBillId(billId);
        context.setProjectId(projectId);
        if ("bos_list".equals(view.getEntityId())) {
            SrcVieUtils.getListVieOperateStatus(context);
        } else {
            SrcVieUtils.setVieOperateStatusContext(context);
            SrcVieUtils.getEditVieOperateStatus(context);
        }
        switch (opkey) {
            case "tblvieagain": 
            case "bar_vieagain": {
                if (context.isVieAgain()) {
                    if (SrcVieUtils.isRegionControl(context)) {
                        OpenFormUtils.openDynamicPage((IFormView)view, (String)"src_vie_again_region", (ShowType)ShowType.Modal, (Map)paraMap, (CloseCallBack)closeCallBack);
                        break;
                    }
                    OpenFormUtils.openDynamicPage((IFormView)view, (String)"src_vie_again", (ShowType)ShowType.Modal, (Map)paraMap, (CloseCallBack)closeCallBack);
                    break;
                }
                view.showTipNotification(context.getVieAgainMsg());
                break;
            }
            case "tblbidstart": 
            case "bar_bidstart": {
                if (context.isBidStart()) {
                    OpenFormUtils.openDynamicPage((IFormView)view, (String)"src_vie_start", (ShowType)ShowType.Modal, (Map)paraMap, (CloseCallBack)closeCallBack);
                    break;
                }
                view.showTipNotification(context.getBidStartMsg());
                break;
            }
            case "tblviehall": 
            case "bar_viehall": {
                if (context.isVieHall()) {
                    String vieturns = PdsVieHelper.getLastVieTurns((long)projectId, null);
                    paraMap.put("vieturns", vieturns);
                    String targetPageId = PdsCommonUtils.object2String((Object)PdsObjectPools.getInstance((String)PdsCommonUtils.getPageIdKey((IFormView)view, (String)"src_compete", (String)(PdsCommonUtils.object2String((Object)projectId, (String)"") + '_' + vieturns))), (String)"");
                    OpenFormUtils.openDynamicPage((IFormView)view, (String)"src_vie_online", (ShowType)ShowType.MainNewTabPage, (Map)paraMap, (CloseCallBack)closeCallBack, (String)targetPageId);
                    break;
                }
                view.showTipNotification(context.getVieHallMsg());
                break;
            }
            case "tblvieanalyse": 
            case "bar_vieanalyse": {
                QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
                OpenFormUtils.openListPage((IFormView)view, (String)"src_vieanalyze", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qfilter, null);
                break;
            }
        }
    }

    private static boolean isRegionControl(SrcVieOperateStatusContext context) {
        DynamicObject vieBillObj = QueryServiceHelper.queryOne((String)"src_vie_rule", (String)"isregioncontrol", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)context.getProjectId())});
        if (null == vieBillObj) {
            return false;
        }
        return vieBillObj.getString("isregioncontrol").equals("1");
    }

    public static String verifyBidStart(long projectId) {
        List verifiers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ISrcBidStartVerifier.class.getSimpleName(), null);
        if (null == verifiers || verifiers.size() == 0) {
            return "succed";
        }
        StringBuilder sb = new StringBuilder();
        for (ISrcBidStartVerifier verifier : verifiers) {
            String result = verifier.verify(projectId);
            if ("succed".equals(result)) continue;
            if (sb.length() > 0) {
                sb.append('\n').append(result);
                continue;
            }
            sb.append(result);
        }
        if (sb == null || sb.length() == 0) {
            return "succed";
        }
        return sb.toString();
    }

    private static String getString(StringBuilder sb) {
        String str = sb.toString();
        if (str.endsWith(";")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static void setNegotiatetypeCombList(IFormView view) {
        List combList;
        HashMap<String, String> combListMap = new HashMap<String, String>(4);
        combListMap.put("1", ResManager.loadKDString((String)"\u7ebf\u4e0a\u8bae\u4ef7", (String)"SrcVieUtils_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
        combListMap.put("2", ResManager.loadKDString((String)"\u7ebf\u4e0b\u8bae\u4ef7(\u6807\u7684)", (String)"SrcVieUtils_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
        boolean isViePublish = view.getModel().getDataEntity().getBoolean("project.isviepublish");
        String sourceType = view.getModel().getDataEntity().getString("project.sourcetype.number");
        if (isViePublish || SourceTypeEnums.VIE.getValue().equals(sourceType) || SourceTypeEnums.ELECTRONIC_AUCTION.getValue().equals(sourceType)) {
            combListMap.put("4", ResManager.loadKDString((String)"\u7535\u5b50\u7ade\u4ef7", (String)"SrcVieUtils_3", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
        if (null == (combList = PdsMetadataUtil.buildPropComboItems(combListMap)) || combList.size() == 0) {
            return;
        }
        ComboEdit fieldsCombo = (ComboEdit)view.getControl("negotiatetype");
        if (null != fieldsCombo) {
            fieldsCombo.setComboItems(combList);
        }
    }

    public static void openVieHallIfRestoftimeOut(IFormView view, String entityId, String pluginName) {
        ExtPluginContext context = new ExtPluginContext();
        context.setProjectId(view.getModel().getDataEntity().getLong("id"));
        context.setView(view);
        context.setEntityId(entityId);
        context.setSourceBill(pluginName);
        ExtPluginFactory.executeExtplugin((String)SrcVieRestoftimeOutOpenVieHall.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
    }
}

