/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.webapi.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;

@ApiController(value="src", desc="\u7b7e\u7ea6")
@ApiMapping(value="src_contract")
public class SrcContractController
implements Serializable {
    private static Log log = LogFactory.getLog(SrcContractController.class);
    private static final long serialVersionUID = 1L;

    @ApiPostMapping(value="deleteContract")
    public CustomApiResult<String> deleteContract(@ApiParam(value="\u7f16\u7801", required=true) @ApiParam(value="\u7f16\u7801", required=true) List<String> billnos) {
        HashSet<Long> unSuccessProjectId = new HashSet<Long>(8);
        QFilter filter = new QFilter("billno", "in", billnos);
        filter.and("systype", "=", (Object)"3");
        DynamicObject[] billObjs = BusinessDataServiceHelper.load((String)"src_contract", (String)"id,billno", (QFilter[])filter.toArray());
        HashMap<String, Cloneable> resultMap = new HashMap<String, Cloneable>(8);
        HashMap<String, String> msgMap = new HashMap<String, String>(8);
        HashSet<Long> successProjectId = new HashSet<Long>(8);
        ArrayList<String> existBillNo = new ArrayList<String>(8);
        ArrayList<String> successBillno = new ArrayList<String>(8);
        ArrayList<String> failBillno = new ArrayList<String>(8);
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        for (DynamicObject billObj : billObjs) {
            long projectId = SrmCommonUtil.getPkValue((DynamicObject)billObj);
            String billno = billObj.getString("billno");
            existBillNo.add(billno);
            try {
                OperateOption option = OperateOption.create();
                option.setVariableValue("isskipsystypevalidate", String.valueOf(true));
                OperationResult result = PdsCommonUtils.doOperation((DynamicObject)billObj, (String)"unaudit", (OperateOption)option);
                if (null != result && !result.isSuccess()) {
                    unSuccessProjectId.add(projectId);
                    StringBuilder errMsg = new StringBuilder();
                    for (int i = 0; i < result.getAllErrorOrValidateInfo().size(); ++i) {
                        errMsg.append(((IOperateInfo)result.getAllErrorOrValidateInfo().get(i)).getMessage()).append('\t');
                    }
                    failBillno.add(billno);
                    msgMap.put(billno, errMsg.toString());
                    continue;
                }
                successObjs.add(billObj);
                successBillno.add(billno);
                successProjectId.add(projectId);
            }
            catch (Exception exception) {
                unSuccessProjectId.add(projectId);
                failBillno.add(billno);
                msgMap.put(billno, exception.getMessage());
            }
        }
        ArrayList<String> noDataBillNos = new ArrayList<String>(billnos);
        noDataBillNos.removeAll(existBillNo);
        for (String billno : noDataBillNos) {
            failBillno.add(billno);
            msgMap.put(billno, ResManager.loadKDString((String)"\u672a\u627e\u5230\u6570\u636e\u6216\u6570\u636e\u6765\u6e90\u7c7b\u578b\u4e0d\u662f\u5916\u90e8\u7cfb\u7edf\u3002", (String)"SrcContractController_3", (String)"scm-src-webapi", (Object[])new Object[0]));
        }
        if (successProjectId.size() > 0) {
            this.beforeHandle(successObjs);
            QFilter delfilter = new QFilter("id", "in", successProjectId);
            int count = DeleteServiceHelper.delete((String)"src_contract", (QFilter[])delfilter.toArray());
            StringBuilder logMsg = new StringBuilder("###SrcContractController del src_contract count:");
            logMsg.append(count);
            log.info(logMsg.toString());
            this.afterHandle(successObjs);
        }
        resultMap.put("successBill", successBillno);
        resultMap.put("failBill", failBillno);
        resultMap.put("errMessage", msgMap);
        String jsonStr = JacksonJsonUtil.toJSON(resultMap);
        if (unSuccessProjectId.size() > 0 || noDataBillNos.size() > 0) {
            return CustomApiResult.fail((String)"400", (String)jsonStr);
        }
        return CustomApiResult.success((Object)jsonStr);
    }

    private void beforeHandle(List<DynamicObject> objs) {
        String extNumber = "ISrcContractDelExoBeforeHandler";
        ExtPluginContext context = new ExtPluginContext();
        context.setTargetObjs(objs);
        List handleList = ExtPluginFactory.getInstance().getExtPluginInstances(extNumber);
        for (IExtPluginHandler handler : handleList) {
            handler.process(context);
        }
    }

    private void afterHandle(List<DynamicObject> objs) {
        String extNumber = "ISrcContractDelExoAfterHandler";
        ExtPluginContext context = new ExtPluginContext();
        context.setTargetObjs(objs);
        List handleList = ExtPluginFactory.getInstance().getExtPluginInstances(extNumber);
        for (IExtPluginHandler handler : handleList) {
            handler.process(context);
        }
    }
}

