/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.src.common.util.SrcBidCompTplUtil;
import kd.scm.src.service.ISrcContractBillService;

public class ISrcContractBillServiceImpl
implements ISrcContractBillService {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(ISrcContractBillServiceImpl.class);

    public Map<String, Object> executeOperate(DynamicObject srcDataEntity, String operationKey) {
        log.info(String.format("\u3010\u7b7e\u7ea6\u751f\u6210\u5408\u540c\u56de\u5199\u3011 -> \u5fae\u670d\u52a1\u63a5\u53e3\u6267\u884c\u5f00\u59cb -> %1$s", srcDataEntity.getString("billno")));
        SrcBidCompTplUtil.updateCurrFlowEntryNode((DynamicObject)srcDataEntity, (String)operationKey);
        SrcBidCompTplUtil.updateCurrentNode((DynamicObject)srcDataEntity);
        DynamicObject currNode = SrcBidCompTplUtil.getCurrNode((DynamicObject)srcDataEntity, (boolean)false);
        Object currNodeId = srcDataEntity.get("currentnode");
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put("currNode", currNode);
        result.put("currNodeId", currNodeId);
        log.info(String.format("\u3010\u7b7e\u7ea6\u751f\u6210\u5408\u540c\u56de\u5199\u3011 -> \u5fae\u670d\u52a1\u63a5\u53e3\u6267\u884c\u7ed3\u675f -> %1$s", srcDataEntity.getString("billno")));
        return result;
    }

    public Map<String, Object> updateContractQty(Map<String, Object> map) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (!map.isEmpty() && map.containsKey("data")) {
            log.info("\u66f4\u65b0\u7b7e\u7ea6\u5355\u5206\u5f55\u6570\u91cf\u53c2\u6570\uff1a" + map);
            Map dataMap = (Map)map.get("data");
            if (!dataMap.isEmpty()) {
                this.updateQty(dataMap, resultMap);
            } else {
                resultMap.put("message", "illeagal parameter!");
                resultMap.put("success", Boolean.FALSE);
            }
        } else {
            resultMap.put("message", "illeagal parameter!");
            resultMap.put("success", Boolean.FALSE);
        }
        return resultMap;
    }

    private boolean updateQty(Map<Long, Object> dataMap, Map<String, Object> map) {
        try {
            HashSet<Long> availablePks = new HashSet<Long>();
            DynamicObject[] dynamicObjectArray = null;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"src_contract", (String)"id,entryentity.id entryid", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", dataMap.keySet())}, (String)"id");){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long id = row.getLong("id");
                    Long entryId = row.getLong("entryid");
                    if (!dataMap.containsKey(entryId)) continue;
                    availablePks.add(id);
                }
            }
            catch (Throwable object) {
                dynamicObjectArray = object;
                throw object;
            }
            if (!availablePks.isEmpty()) {
                DynamicObject[] contracts;
                for (DynamicObject contract : contracts = BusinessDataServiceHelper.load((String)"src_contract", (String)"entryentity.orderqty,entryentity.qty", (QFilter[])new QFilter[]{new QFilter("id", "in", availablePks)})) {
                    DynamicObjectCollection entryentity = contract.getDynamicObjectCollection("entryentity");
                    for (DynamicObject row : entryentity) {
                        Long entryPk = row.getLong("id");
                        Object dataObj = dataMap.get(entryPk);
                        if (dataObj == null) continue;
                        row.set("orderqty", (Object)row.getBigDecimal("orderqty").add(new BigDecimal(dataObj.toString())));
                    }
                }
                SaveServiceHelper.save((DynamicObject[])contracts);
                map.put("success", Boolean.TRUE);
                map.put("message", ResManager.loadKDString((String)"\u7b7e\u7ea6\u5355\u6570\u91cf\u5df2\u66f4\u65b0\u3002", (String)"ISrcContractBillServiceImpl_2", (String)"scm-src-mservice", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            map.put("success", Boolean.FALSE);
            map.put("message", e.getMessage());
            log.error(ExceptionUtil.getStackTrace((Throwable)e));
            return false;
        }
        return true;
    }

    public List<Long> qtyexcessList(Map<Long, BigDecimal> parammap) {
        DynamicObject[] contracts;
        log.info("\u8ba2\u5355\u5173\u8054\u6570\u91cf\u6821\u9a8c\u8bf7\u6c42\u53c2\u6570\uff1a" + parammap);
        ArrayList<Long> resultIds = new ArrayList<Long>();
        Set<Long> keySet = parammap.keySet();
        QFilter filter = new QFilter("entryentity.id", "in", keySet);
        for (DynamicObject contract : contracts = BusinessDataServiceHelper.load((String)"src_contract", (String)"entryentity.id,entryentity.qty,entryentity.orderqty", (QFilter[])filter.toArray())) {
            DynamicObjectCollection entryentity = contract.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                BigDecimal orderqty;
                BigDecimal qty = entry.getBigDecimal("qty");
                if (qty.compareTo((orderqty = entry.getBigDecimal("orderqty")).add(parammap.get(entry.getPkValue()))) >= 0) continue;
                resultIds.add((Long)entry.getPkValue());
            }
        }
        return resultIds;
    }
}

