/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class SrcDbUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(SrcDbUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog("start upgrade mallgoods");
            ArrayList<String> filedList = new ArrayList<String>(2);
            filedList.add("fitem");
            filedList.add("fnote");
            this.upgrade("scm", filedList, "fentryid", "t_src_indexentry", "t_src_indexentry_l", pProcessInfo);
            ArrayList<String> filedList1 = new ArrayList<String>(4);
            filedList1.add("findexdimension");
            filedList1.add("findex");
            filedList1.add("findexrule");
            filedList1.add("fnote");
            this.upgrade("scm", filedList1, "fentryid", "t_src_schemeindex", "t_src_schemeindex_l", pProcessInfo);
            ArrayList<String> filedList2 = new ArrayList<String>(2);
            filedList2.add("fitem");
            filedList2.add("fnote");
            this.upgrade("scm", filedList2, "fdetailid", "t_src_schemerule", "t_src_schemerule_l", pProcessInfo);
            ArrayList<String> filedList5 = new ArrayList<String>(2);
            filedList5.add("faptitudename");
            filedList5.add("fissueorg");
            this.upgrade("scm", filedList5, "fentryid", "t_src_expertaptitude", "t_src_expertaptitude_l", pProcessInfo);
            ArrayList<String> filedList6 = new ArrayList<String>(2);
            filedList6.add("frequest");
            filedList6.add("fremark");
            this.upgrade("scm", filedList6, "fentryid", "t_src_bizschemeentry", "t_src_bizschemeentry_l", pProcessInfo);
            ArrayList<String> filedList9 = new ArrayList<String>(2);
            filedList9.add("findexdimension");
            filedList9.add("findexrule");
            this.upgrade("scm", filedList9, "fid", "t_src_index", "t_src_index_l", pProcessInfo);
            ArrayList<String> filedList10 = new ArrayList<String>(1);
            filedList10.add("fdescription");
            this.upgrade("scm", filedList10, "fid", "t_src_grade", "t_src_grade_l", pProcessInfo);
            ArrayList<String> filedList12 = new ArrayList<String>(1);
            filedList12.add("fremark");
            this.upgrade("scm", filedList12, "fid", "t_src_openscheme", "t_src_openscheme_l", pProcessInfo);
            ArrayList<String> filedList15 = new ArrayList<String>(1);
            filedList15.add("fremark");
            this.upgrade("scm", filedList15, "fid", "t_src_bizscheme", "t_src_bizscheme_l", pProcessInfo);
            ArrayList<String> filedList16 = new ArrayList<String>(1);
            filedList16.add("fremark");
            this.upgrade("scm", filedList16, "fid", "t_src_bizitem", "t_src_bizitem_l", pProcessInfo);
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            throw new KDBizException(result.getErrorInfo());
        }
        return result;
    }

    public boolean upgrade(String dbKey, List<String> filedList, String idFiledName, String srcTableName, String tarTablename, StringBuilder pProcessInfo) {
        int pageSize = 2000;
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select ").append(idFiledName);
        for (String string : filedList) {
            selectSql.append(", ").append(string);
        }
        selectSql.append(" from  ").append(srcTableName);
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ").append(tarTablename).append(" set ").append(idFiledName).append(" = ? ");
        for (String filed : filedList) {
            updateSql.append(", ").append(filed).append(" = ? ");
        }
        updateSql.append(" where  ").append(idFiledName).append(" = ? ").append("and flocaleid = 'zh_CN'");
        try (DataSet dataSet = this.getDataSet(dbKey, selectSql.toString());){
            ArrayList<Object[]> allParamsList = new ArrayList<Object[]>(2048);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ArrayList<Object> paramsList = new ArrayList<Object>(filedList.size() + 2);
                paramsList.add(row.get(idFiledName));
                for (String filed : filedList) {
                    paramsList.add(row.get(filed));
                }
                paramsList.add(row.get(idFiledName));
                allParamsList.add(paramsList.toArray());
                if (allParamsList.size() <= pageSize) continue;
                this.updateBatch(dbKey, updateSql.toString(), allParamsList);
                allParamsList.clear();
            }
            if (allParamsList.size() > 0) {
                this.updateBatch(dbKey, updateSql.toString(), allParamsList);
            }
        }
        return true;
    }

    private void updateBatch(String dbKey, String updateSql, List<Object[]> paramsList) {
        DBRoute dbRoute = DBRoute.of((String)dbKey);
        DB.executeBatch((DBRoute)dbRoute, (String)updateSql, paramsList);
    }

    private DataSet getDataSet(String dbKey, String sql) {
        DBRoute dbRoute = DBRoute.of((String)dbKey);
        return DB.queryDataSet((String)RequestContext.get().getTraceId(), (DBRoute)dbRoute, (String)sql);
    }
}

