/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.attach;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.attach.IPdsAttachHandler;
import kd.scm.pds.common.attach.PdsAttachContext;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcNegotiateUtil;

public class SrcQuoteBillAttachHandler
implements IPdsAttachHandler {
    private static final long serialVersionUID = 1L;

    public List<Map<String, Object>> getAttachments(PdsAttachContext context) {
        QFilter qfilters = new QFilter("project", "=", (Object)context.getBillId());
        qfilters.and("billstatus", ">=", (Object)BillStatusEnum.AUDIT.getVal());
        Set unOpenStatusSet = PdsCommonUtils.buildSet((String[])new String[]{BidOpenStatusEnums.NOOPEN.getValue(), BidOpenStatusEnums.NEGOTIATE.getValue()});
        QFilter statusFilter = new QFilter("project.openstatus", "not in", (Object)unOpenStatusSet);
        String lastTurns = SrcNegotiateUtil.getLastTurns(context.getBillId());
        statusFilter.or("turns", "<", (Object)lastTurns);
        qfilters.and(statusFilter);
        List attachs = AttachmentUtils.getBillAttachment((String)"tnd_quotebill", (QFilter)qfilters, (String)"attachmentpanel");
        if (null == attachs || attachs.size() == 0) {
            return null;
        }
        AttachmentUtils.sortAttachment((List)attachs, (String)"name");
        AttachmentUtils.setAttachmentType((List)attachs, (String)ResManager.loadKDString((String)"\u62a5\u4ef7\u5355\u9644\u4ef6", (String)"SrcQuoteBillAttachHandler_0", (String)"scm-src-common", (Object[])new Object[0]));
        return attachs;
    }
}

