/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.task.IPdsAutoTaskExecutor;
import kd.scm.pds.common.task.PdsAutoTaskContext;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.util.SrcProjectLockUtil;

public class SrcBidAutoOpenService
implements IPdsAutoTaskExecutor {
    private static final long serialVersionUID = 1L;

    public synchronized void execute(PdsAutoTaskContext taskContext) {
        DynamicObject[] projectObjs;
        QFilter qfilters = this.buildQFilter();
        DynamicObjectCollection openObjs = QueryServiceHelper.query((String)"src_bidopen_open", (String)"id,stopbiddate", (QFilter[])qfilters.toArray());
        if (openObjs == null || openObjs.size() == 0) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"%1$s--\u81ea\u52a8\u5f00\u6807\uff1a\u6ca1\u6709\u7b26\u5408\u81ea\u52a8\u5f00\u6807\u6761\u4ef6\u7684\u9879\u76ee\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a%2$s\u3002", (String)"SrcBidAutoOpenService_0", (String)"scm-src-common", (Object[])new Object[0]), this.getClass(), qfilters.toString()));
            return;
        }
        StringBuilder message = new StringBuilder();
        Object[] pkIds = new Object[openObjs.size()];
        for (int i = 0; i < openObjs.size(); ++i) {
            pkIds[i] = ((DynamicObject)openObjs.get(i)).getLong("id");
        }
        Map<String, Object> bidChangeObjMap = this.getBidChangeObjMap(pkIds);
        DynamicObject compareObj = BusinessDataServiceHelper.newDynamicObject((String)"src_compare");
        for (DynamicObject projectObj : projectObjs = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)compareObj.getDynamicObjectType())) {
            long projectId = projectObj.getLong("id");
            if (null != bidChangeObjMap.get(String.valueOf(projectId))) continue;
            String result = SrcBidOpenFacade.bidAutoOpenVerify(projectObj);
            if (!"succed".equals(result)) {
                BizLog.log((String)String.format(ResManager.loadKDString((String)"%1$s\uff1a\u81ea\u52a8\u5f00\u6807\u6821\u9a8c\u5931\u8d25\uff0c\u76f8\u5173\u4fe1\u606f\uff1a%2$s\u3002", (String)"SrcBidAutoOpenService_1", (String)"scm-src-common", (Object[])new Object[0]), this.getClass(), result));
                continue;
            }
            String lockKey = SrcProjectLockUtil.getBidAutoLockKey(projectId);
            if (!SrcProjectLockUtil.tryLockProject(lockKey)) continue;
            QFilter packageFilter = new QFilter("billid", "=", (Object)projectId);
            QFilter tecFilter = new QFilter("project", "=", (Object)projectId).and("entrystatus", "=", (Object)ProjectStatusEnums.QUOTED.getValue());
            QFilter bizFilter = new QFilter("project", "=", (Object)projectId).and("entrystatus", "=", (Object)ProjectStatusEnums.QUOTED.getValue());
            boolean isPushScoreTask = false;
            boolean isSucced = true;
            try (TXHandle tx = TX.requiresNew();){
                try {
                    isPushScoreTask = this.openBidDoc(tecFilter, bizFilter, message);
                    this.openQuoteBill(bizFilter, message);
                    SrcBidOpenFacade.setPackageOpenStatus(projectObj, packageFilter);
                }
                catch (Exception e) {
                    isSucced = false;
                    tx.markRollback();
                }
            }
            if (isSucced) {
                SrcBidOpenFacade.setProjectOpenStatus(projectId);
                if (isPushScoreTask) {
                    SrcBidOpenFacade.pushScoreTask(null, projectObj, "allopen", Collections.emptyList());
                }
                SrcBidOpenFacade.synthCalculate("src_compare", projectId);
            }
            SrcProjectLockUtil.unLockProject(lockKey);
        }
        if (message.length() > 0) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"%1$s\uff1a\u81ea\u52a8\u5f00\u6807\u5931\u8d25\uff0c\u76f8\u5173\u4fe1\u606f\uff1a%2$s\u3002", (String)"SrcBidAutoOpenService_2", (String)"scm-src-common", (Object[])new Object[0]), this.getClass(), message.toString()));
        }
    }

    private QFilter buildQFilter() {
        Date currentDate = TimeServiceHelper.now();
        QFilter qfilters = new QFilter("openstatus", "=", (Object)"1");
        qfilters.and("stopbiddate", "<=", (Object)currentDate);
        qfilters.and("isautoopen", "=", (Object)"1");
        QFilter nodeFilter = new QFilter("currentnode.number", "=", (Object)PdsBizNodeEnums.BIDASSESS.getValue());
        nodeFilter.or("currentnode.number", "=", (Object)PdsBizNodeEnums.SCORERTASK.getValue());
        nodeFilter.or("currentnode.number", "=", (Object)PdsBizNodeEnums.COMPARE.getValue());
        nodeFilter.or("currentnode.number", "=", (Object)PdsBizNodeEnums.DECISION.getValue());
        qfilters.and(nodeFilter);
        return qfilters;
    }

    private boolean openBidDoc(QFilter tecFilter, QFilter bizFilter, StringBuilder message) {
        Map<String, Object> resultMap = SrcBidOpenFacade.openBidDoc("allopen", tecFilter, bizFilter, null);
        if (!((Boolean)resultMap.get("succed")).booleanValue()) {
            message.append(resultMap.get("message"));
            return false;
        }
        return true;
    }

    private void openQuoteBill(QFilter bizFilter, StringBuilder message) {
        Map<String, Object> resultMap = SrcBidOpenFacade.openPurlist(bizFilter);
        if (!((Boolean)resultMap.get("succed")).booleanValue()) {
            message.append(resultMap.get("message"));
        }
    }

    private Map<String, Object> getBidChangeObjMap(Object[] pkIds) {
        HashMap<String, Object> bidChangeObjMap = new HashMap<String, Object>(8);
        QFilter bidChangeFilter = new QFilter("project", "in", (Object)pkIds);
        bidChangeFilter.and("template.number", "=", (Object)"SYS036");
        bidChangeFilter.and("billstatus", "=", (Object)"B");
        DynamicObjectCollection bidChangeCols = QueryServiceHelper.query((String)"src_bidchange", (String)"id,project", (QFilter[])bidChangeFilter.toArray());
        for (DynamicObject bidChange : bidChangeCols) {
            bidChangeObjMap.put(String.valueOf(bidChange.getLong("project")), bidChange);
        }
        return bidChangeObjMap;
    }
}

