/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.entity.PdsObjectPools;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.util.SrcBidCompTplUtil;
import kd.scm.src.common.util.SrcComponentUtil;

public class SrcBidOpenUtils {
    public static Set<Long> getSelectPackageIds(IFormView view) {
        String bidopen_open = SrcBidOpenFacade.getBidOpenNameMap(view.getModel().getDataEntity()).get("src_bidopen_open");
        IFormView compView = SrcComponentUtil.getComponentView(view, bidopen_open);
        if (null == compView) {
            return Collections.emptySet();
        }
        DynamicObjectCollection rows = compView.getModel().getEntryEntity("entryentity");
        return rows.stream().filter(row -> row.getBoolean("istecopen") || row.getBoolean("isbizopen") || row.getBoolean("isaptopen")).map(row -> SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("package"))).collect(Collectors.toSet());
    }

    public static Set<Long> getSelectPackageIds(IFormView view, BeforeDoOperationEventArgs args, String opKey) {
        String bidopen_open = SrcBidOpenFacade.getBidOpenNameMap(view.getModel().getDataEntity()).get("src_bidopen_open");
        IFormView compView = SrcComponentUtil.getComponentView(view, bidopen_open);
        HashSet<Long> selectPackageIds = new HashSet<Long>(16);
        List<Integer> selectIndexs = SrcBidOpenUtils.getSelectIndexs(view, args, opKey);
        for (int i = 0; i < selectIndexs.size(); ++i) {
            DynamicObject row = compView.getModel().getEntryRowEntity("entryentity", selectIndexs.get(i).intValue());
            selectPackageIds.add(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("package")));
        }
        return selectPackageIds;
    }

    public static Set<Long> getSelectSupplierIds(IFormView view, BeforeDoOperationEventArgs args, String opKey) {
        String bidopen_open = SrcBidOpenFacade.getBidOpenNameMap(view.getModel().getDataEntity()).get("src_bidopen_open");
        IFormView compView = SrcComponentUtil.getComponentView(view, bidopen_open);
        HashSet<Long> selectSupplierIds = new HashSet<Long>(16);
        List<Integer> selectIndexs = SrcBidOpenUtils.getSelectIndexs(view, args, opKey);
        for (int i = 0; i < selectIndexs.size(); ++i) {
            DynamicObject row = compView.getModel().getEntryRowEntity("entryentity", selectIndexs.get(i).intValue());
            selectSupplierIds.add(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("supplier")));
        }
        return selectSupplierIds;
    }

    public static List<Integer> getSelectIndexs(IFormView view, BeforeDoOperationEventArgs args, String opKey) {
        String bidopen_open = SrcBidOpenFacade.getBidOpenNameMap(view.getModel().getDataEntity()).get("src_bidopen_open");
        IFormView compView = SrcComponentUtil.getComponentView(view, bidopen_open);
        if (Objects.isNull(compView)) {
            return Collections.EMPTY_LIST;
        }
        DynamicObject compObj = compView.getModel().getDataEntity(true);
        DynamicObjectCollection rows = compObj.getDynamicObjectCollection("entryentity");
        boolean ismultipackage = compObj.getBoolean("ismultipackage");
        boolean isbypackage = false;
        boolean isOpenBySupplier = false;
        if (bidopen_open.equals("src_supplier_open")) {
            boolean isNodeRank = compView.getModel().getDataEntity().getBoolean("isnoderank");
            isOpenBySupplier = true;
            String supOpenType = compObj.getString("supopentype");
            if ("2".equals(supOpenType) || "3".equals(supOpenType)) {
                List<Integer> indexList = null;
                String key = String.valueOf(PdsCommonUtils.object2Long((Object)view.getModel().getDataEntity().getPkValue())) + '_' + view.getEntityId() + '_' + "index" + '_' + String.valueOf(RequestContext.get().getCurrUserId());
                Object indexListObj = PdsObjectPools.getInstance((String)key);
                if (null != indexListObj) {
                    indexList = (List<Integer>)indexListObj;
                    PdsObjectPools.removeInstance((String)key);
                }
                if ((null == indexList || indexList.size() == 0) && (indexList = SrcBidOpenUtils.getRandomOrSortedIndex(opKey, compObj, supOpenType, view.getEntityId(), isNodeRank)).size() > 0) {
                    PdsObjectPools.putInstance((String)key, indexList);
                }
                if (indexList.size() == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u5f85\u5f00\u6807\u7684\u5206\u5f55\uff0c\u4e0d\u80fd\u8fdb\u884c\u5f00\u6807\u5904\u7406\u3002", (String)"SrcBidOpenUtils_3", (String)"scm-src-common", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                return indexList;
            }
        } else {
            isbypackage = compObj.getBoolean("isbypackage");
            if (view.getEntityId().equals("src_aptitudeaudit")) {
                isbypackage = compObj.getBoolean("isbypackage_apt");
            }
        }
        EntryGrid grid = (EntryGrid)compView.getControl("entryentity");
        ArrayList<Integer> selectIndexs = new ArrayList<Integer>();
        if (ismultipackage && isbypackage || isOpenBySupplier) {
            int[] indexs = grid.getSelectRows();
            if (indexs == null || indexs.length == 0) {
                if (isOpenBySupplier) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u9700\u8981\u5206\u4f9b\u5e94\u5546\u5f00\u6807\uff0c\u8bf7\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u4f9b\u5e94\u5546\u3002", (String)"SrcBidOpenUtils_4", (String)"scm-src-common", (Object[])new Object[0]));
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u9700\u8981\u5206\u6807\u6bb5\u5f00\u6807\uff0c\u8bf7\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u6807\u6bb5\u3002", (String)"SrcBidOpenUtils_5", (String)"scm-src-common", (Object[])new Object[0]));
                }
                if (Objects.nonNull(args)) {
                    args.setCancel(true);
                }
                return Collections.emptyList();
            }
            if (isOpenBySupplier && indexs.length > 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u6309\u4f9b\u5e94\u5546\u5f00\u6807\uff0c\u6bcf\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u5bb6\u4f9b\u5e94\u5546\u8fdb\u884c\u5f00\u6807\u3002", (String)"SrcBidOpenUtils_6", (String)"scm-src-common", (Object[])new Object[0]));
                args.setCancel(true);
            }
            for (int index : indexs) {
                selectIndexs.add(index);
            }
        } else {
            for (int i = 0; i < rows.size(); ++i) {
                selectIndexs.add(i);
            }
        }
        return selectIndexs;
    }

    public static List<Integer> getRandomOrSortedIndex(String opKey, DynamicObject compObj, String supOpenType, String entityName, boolean isNodeRank) {
        DynamicObject row2;
        DynamicObject[] supRows;
        DynamicObjectCollection rows = compObj.getDynamicObjectCollection("entryentity");
        if (rows.size() == 0) {
            return Collections.emptyList();
        }
        List sortedList = null;
        sortedList = "aptopen".equals(opKey) ? rows.stream().filter(e -> !e.getBoolean("isaptopen")).sorted(Comparator.comparing(row -> row.getInt("rank"))).collect(Collectors.toList()) : ("bizopen".equals(opKey) ? rows.stream().filter(e -> e.getBoolean("istecopen") && !e.getBoolean("isbizopen")).sorted(Comparator.comparing(row -> row.getInt("rank"))).collect(Collectors.toList()) : rows.stream().filter(e -> !e.getBoolean("istecopen")).sorted(Comparator.comparing(row -> row.getInt("rank"))).collect(Collectors.toList()));
        if (null == sortedList || sortedList.size() == 0) {
            return Collections.emptyList();
        }
        if ("2".equals(supOpenType) && ((DynamicObject)sortedList.get(0)).getInt("rank") == 0) {
            Collections.shuffle(sortedList);
            Set idSet = sortedList.stream().map(e -> e.getLong("srcentryid")).collect(Collectors.toSet());
            supRows = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)"rank,aptrank,tecrank,bizrank", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
            int rank = 1;
            for (DynamicObject obj : sortedList) {
                for (DynamicObject supRow : supRows) {
                    if (supRow.getLong("id") != obj.getLong("srcentryid")) continue;
                    SrcBidOpenUtils.updateRank(supRow, rank, entityName, isNodeRank);
                    break;
                }
                ++rank;
            }
            PdsCommonUtils.saveDynamicObjects((DynamicObject[])supRows);
        }
        int index = 0;
        supRows = rows.iterator();
        while (supRows.hasNext() && (row2 = (DynamicObject)supRows.next()).getLong("srcentryid") != ((DynamicObject)sortedList.get(0)).getLong("srcentryid")) {
            ++index;
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>(1);
        indexList.add(index);
        return indexList;
    }

    public static String getOpenType(IFormView view) {
        DynamicObject billObj = view.getModel().getDataEntity();
        String openType = billObj.getString("opentype");
        if (StringUtils.isBlank((CharSequence)openType)) {
            openType = SrcBidCompTplUtil.hasNode(billObj, "src_bidassess") ? "2" : "1";
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
        }
        return openType;
    }

    public static boolean isOfflineScore(long projectId) {
        DynamicObject bidOpenCfgObj = QueryServiceHelper.queryOne((String)"src_bidopen_config", (String)"scoretype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)});
        if (null == bidOpenCfgObj) {
            return false;
        }
        return "2".equals(bidOpenCfgObj.getString("scoretype"));
    }

    public static boolean isAptitudeAudit2Open(IFormView view, String opkey) {
        if (Objects.equals(view.getEntityId(), "src_aptitudeaudit2")) {
            return Objects.equals(opkey, "allopen") || Objects.equals(opkey, "tecopen") || Objects.equals(opkey, "bizopen") || Objects.equals(opkey, "aptopen");
        }
        return false;
    }

    public static boolean isManualBidBaseValue(DynamicObject projectObj, DynamicObject schemeObj) {
        if (null == schemeObj || null == projectObj || projectObj.getDataEntityType().getName().equals("bos_list")) {
            return false;
        }
        if ("6".equals(schemeObj.getString("ranktype"))) {
            long sourceFlowId = projectObj.getLong("srctype.id");
            return ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isManualBidBaseValue", (Object)false, (long)projectObj.getLong("id")));
        }
        return false;
    }

    public static void setProjectSchemeValue(IFormView view, PropertyChangedArgs evt) {
        int index = evt.getChangeSet()[0].getRowIndex();
        DynamicObject row = view.getModel().getEntryRowEntity("entryentity", index);
        long schemeId = row.getLong("scheme.id");
        if (schemeId == 0L) {
            view.getModel().setValue("proscheme", null);
            return;
        }
        QFilter qfilter = new QFilter("projectid", "=", (Object)view.getParentView().getModel().getDataEntity().getLong("id"));
        qfilter.and("schemeid", "=", (Object)schemeId);
        DynamicObject proSchemeObj = QueryServiceHelper.queryOne((String)"src_scheme", (String)"id", (QFilter[])qfilter.toArray());
        if (null == proSchemeObj) {
            view.getModel().setValue("proscheme", null);
            return;
        }
        view.getModel().setValue("proscheme", (Object)proSchemeObj.getLong("id"));
    }

    public static boolean isOpenTecBeforePublish(DynamicObject projectObj) {
        if (null == projectObj) {
            return false;
        }
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)projectObj.getDynamicObject("srctype"));
        return PdsCommonUtils.object2Boolean((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isOpenTecBeforePublish", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)projectObj)));
    }

    public static void updateRank(DynamicObject row, int rank, String entityName, boolean isNodeRank) {
        row.set("rank", (Object)rank);
        if (isNodeRank) {
            switch (entityName) {
                case "src_aptitudeaudit": {
                    row.set("aptrank", (Object)rank);
                    break;
                }
                case "src_bidassess": {
                    row.set("tecrank", (Object)rank);
                    break;
                }
                case "src_compare": {
                    row.set("bizrank", (Object)rank);
                    break;
                }
                default: {
                    row.set("tecrank", (Object)rank);
                    row.set("bizrank", (Object)rank);
                    break;
                }
            }
        } else {
            row.set("aptrank", (Object)rank);
            row.set("tecrank", (Object)rank);
            row.set("bizrank", (Object)rank);
        }
    }
}

