/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen.bidopencomm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.util.SrcProjectLockUtil;

public class SrcBidAutoOpenByOpenType
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        String result = SrcBidOpenFacade.bidAutoOpenVerify(context.getProjectObj(), context.getOperationKey());
        if (!"succed".equals(result)) {
            context.setMessage(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u5f00\u6807\u6821\u9a8c\u5931\u8d25\uff0c\u76f8\u5173\u4fe1\u606f\uff1a%1$s\u3002", (String)"SrcBidAutoOpenByOpenType_1", (String)"scm-src-common", (Object[])new Object[0]), result));
            context.setSucced(false);
            return;
        }
        long projectId = context.getProjectId();
        String lockKey = SrcProjectLockUtil.getBidAutoLockKey(projectId);
        if (!SrcProjectLockUtil.tryLockProject(lockKey)) {
            context.setSucced(false);
            return;
        }
        StringBuilder message = new StringBuilder();
        QFilter packageFilter = new QFilter("billid", "=", (Object)projectId);
        if (null != context.getPackageIds() && context.getPackageIds().size() > 0) {
            packageFilter.and("package", "in", (Object)context.getPackageIds());
        }
        QFilter tecFilter = new QFilter("project", "=", (Object)projectId);
        tecFilter.and("entrystatus", "=", (Object)ProjectStatusEnums.QUOTED.getValue());
        if (null != context.getPackageIds() && context.getPackageIds().size() > 0) {
            tecFilter.and("package", "in", (Object)context.getPackageIds());
        }
        QFilter bizFilter = new QFilter("project", "=", (Object)projectId);
        bizFilter.and("entrystatus", "=", (Object)ProjectStatusEnums.QUOTED.getValue());
        if (null != context.getPackageIds() && context.getPackageIds().size() > 0) {
            bizFilter.and("package", "in", (Object)context.getPackageIds());
        }
        QFilter aptFilter = new QFilter("project", "=", (Object)projectId);
        aptFilter.and("entrystatus", "=", (Object)ProjectStatusEnums.QUOTED.getValue());
        if (null != context.getPackageIds() && context.getPackageIds().size() > 0) {
            aptFilter.and("package", "in", (Object)context.getPackageIds());
        }
        boolean isPushScoreTask = false;
        boolean isSucced = true;
        try (TXHandle tx = TX.requiresNew();){
            try {
                isPushScoreTask = this.openBidDoc(context.getOperationKey(), tecFilter, bizFilter, aptFilter, message);
                if ("allopen".equals(context.getOperationKey()) || "bizopen".equals(context.getOperationKey())) {
                    this.openQuoteBill(bizFilter, message);
                }
                this.setPackageOpenStatus(context, packageFilter);
            }
            catch (Exception e) {
                isSucced = false;
                tx.markRollback();
            }
        }
        if (isSucced) {
            if (isPushScoreTask) {
                SrcBidOpenFacade.pushScoreTask(null, context.getProjectObj(), "allopen", Collections.emptyList(), context.getOperationKey());
            }
            SrcBidOpenFacade.setProjectOpenStatus(projectId);
            if ("allopen".equals(context.getOperationKey()) || "bizopen".equals(context.getOperationKey())) {
                SrcBidOpenFacade.synthCalculate("src_compare", projectId);
            }
        }
        context.setSucced(isSucced);
        context.setMessage(message);
        SrcProjectLockUtil.unLockProject(lockKey);
    }

    public boolean openBidDoc(String openType, QFilter tecFilter, QFilter bizFilter, QFilter aptFilter, StringBuilder message) {
        Map<String, Object> resultMap = SrcBidOpenFacade.openBidDoc(openType, tecFilter, bizFilter, aptFilter);
        if (!((Boolean)resultMap.get("succed")).booleanValue()) {
            message.append(resultMap.get("message"));
            return false;
        }
        return true;
    }

    public void openQuoteBill(QFilter bizFilter, StringBuilder message) {
        Map<String, Object> resultMap = SrcBidOpenFacade.openPurlist(bizFilter);
        if (!((Boolean)resultMap.get("succed")).booleanValue()) {
            message.append(resultMap.get("message"));
        }
    }

    public void setPackageOpenStatus(ExtPluginContext context, QFilter packageFilter) {
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_bidopenpackage", (boolean)false);
        DynamicObject[] packageObjs = BusinessDataServiceHelper.load((String)"src_bidopenpackage", (String)selectFields, (QFilter[])packageFilter.toArray());
        ArrayList<DynamicObject> packageList = new ArrayList<DynamicObject>(packageObjs.length);
        for (DynamicObject packageObj : packageObjs) {
            String opKey = context.getOperationKey();
            if (opKey.equals("allopen") || opKey.equals("tecopen")) {
                SrcBidOpenFacade.updateTecOpenStatus(packageObj);
            }
            if (opKey.equals("allopen") || opKey.equals("bizopen")) {
                SrcBidOpenFacade.updateBizOpenStatus(packageObj);
            }
            if (opKey.equals("aptopen")) {
                SrcBidOpenFacade.updateAptOpenStatus(packageObj);
            }
            packageList.add(packageObj);
        }
        PdsCommonUtils.saveDynamicObjects(packageList);
    }
}

