/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen.bidopencomm;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.src.common.bidopen.ISrcBidOpenHandler;
import kd.scm.src.common.bidopen.SrcBidOpenContext;

public class SrcBidOpenAptHandle
implements ISrcBidOpenHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcBidOpenContext context) {
        this.handleAptBid(context);
    }

    private void handleAptBid(SrcBidOpenContext context) {
        IFormView view = context.getView();
        DynamicObject row = context.getRow();
        List<Long> aptList = context.getAptList();
        List<Long> supList = context.getSupList();
        StringBuilder sb = context.getSb();
        DynamicObject[] packageObjs = context.getPackageObjs();
        if (!row.getBoolean("isaptopen")) {
            this.setAptBid(context, view, row, aptList, sb, packageObjs, supList);
        }
    }

    private void setAptBid(SrcBidOpenContext context, IFormView view, DynamicObject row, List<Long> aptList, StringBuilder sb, DynamicObject[] packageObjs, List<Long> supList) {
        boolean isNeedOpenApt = false;
        DynamicObjectCollection flowRows = view.getModel().getDataEntity(true).getDynamicObjectCollection("entrymainflow");
        for (DynamicObject flowRow : flowRows) {
            String node = flowRow.getString("biznode.number");
            if (!PdsBizNodeEnums.APTITUDEAUDIT.getValue().equals(node) && !PdsBizNodeEnums.APTITUDEAUDIT2.getValue().equals(node)) continue;
            isNeedOpenApt = true;
            break;
        }
        for (DynamicObject packageObj : packageObjs) {
            Object pkId;
            Object object = pkId = context.isOpenBySupplier() ? Long.valueOf(row.getLong("srcentryid")) : row.getPkValue();
            if (!packageObj.getPkValue().equals(pkId)) continue;
            packageObj.set("isaptopen", (Object)"1");
            packageObj.set("aptopendate", (Object)TimeServiceHelper.now());
            packageObj.set("aptopenuser", (Object)RequestContext.get().getCurrUserId());
            if (row.getDynamicObject("package") == null) continue;
            if (isNeedOpenApt) {
                if (context.isOpenBySupplier()) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546(%1$s)\u5c06\u5f00\u8d44\u5ba1\u6807,", (String)"SrcBidOpenAptHandle_2", (String)"scm-src-common", (Object[])new Object[0]), row.getString("supplier.name")));
                } else if (((Boolean)view.getModel().getValue("ismultipackage")).booleanValue()) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u6807\u6bb5(%1$s)\u5c06\u5f00\u8d44\u5ba1\u6807,", (String)"SrcBidOpenAptHandle_0", (String)"scm-src-common", (Object[])new Object[0]), row.getDynamicObject("package").getString("packagename")));
                } else {
                    sb.append(ResManager.loadKDString((String)"\u9879\u76ee({0})\u5c06\u5f00\u8d44\u5ba1\u6807,", (String)"SrcBidOpenAptHandle_3", (String)"scm-src-common", (Object[])new Object[]{view.getModel().getDataEntity().getString("bidname")}));
                }
            }
            aptList.add(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("package")));
            if (!context.isOpenBySupplier()) continue;
            supList.add(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("supplier")));
        }
    }
}

