/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen.bidopencomm;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bidopen.ISrcBidOpenHandler;
import kd.scm.src.common.bidopen.SrcBidOpenContext;
import kd.scm.src.common.util.SrcAptitudeUtils;

public class SrcBidOpenAptOldDataDelete
implements ISrcBidOpenHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcBidOpenContext context) {
        this.deleteOldData(context);
    }

    protected void deleteOldData(SrcBidOpenContext context) {
        IFormView view = context.getView();
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity());
        this.invalidScoreTask(view, projectId);
        this.deleteAptitudeResult(view, projectId);
        this.deleteSuggestion(view, projectId);
        this.updateAptitudeConfig(view, projectId);
        this.updateSupplier(view, projectId, "src_bidopensupplier");
        this.updateSupplier(view, projectId, "src_supplierinvite");
        this.updateSupplier(view, projectId, "src_enrollsupplier");
    }

    protected void invalidScoreTask(IFormView view, long projectId) {
        QFilter taskFilter = new QFilter("project", "=", (Object)projectId);
        if (view.getEntityId().equals("src_aptitudeaudit")) {
            taskFilter.and("indextype.basetype", "=", (Object)"4");
        } else {
            taskFilter.and("indextype.basetype", "=", (Object)"7");
        }
        if (SrcAptitudeUtils.isSupplierReplyAptitude(view.getModel().getDataEntity())) {
            DeleteServiceHelper.delete((String)"src_scoretask", (QFilter[])taskFilter.toArray());
        } else {
            taskFilter.and("bizstatus", "!=", (Object)"E");
            DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_scoretask", (String)"bizstatus", (QFilter[])taskFilter.toArray());
            if (rows.length == 0) {
                return;
            }
            for (DynamicObject row : rows) {
                row.set("bizstatus", (Object)"E");
            }
            PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
        }
    }

    protected void deleteAptitudeResult(IFormView view, long projectId) {
        QFilter resultFilter = new QFilter("billid", "=", (Object)projectId);
        DeleteServiceHelper.delete((String)SrcAptitudeUtils.getAptitudeResultF7Key(view), (QFilter[])resultFilter.toArray());
    }

    protected void deleteSuggestion(IFormView view, long projectId) {
        QFilter sugFilter = new QFilter("billid.project", "=", (Object)projectId);
        if (view.getEntityId().equals("src_aptitudeaudit")) {
            sugFilter.and("billid.basetype", "=", (Object)"4");
        } else {
            sugFilter.and("billid.basetype", "=", (Object)"7");
        }
        DeleteServiceHelper.delete((String)"src_scoresuggestionf7", (QFilter[])sugFilter.toArray());
        String billId = null;
        billId = view.getEntityId().equals("src_aptitudeaudit") ? String.valueOf(projectId) + '_' + "4" : String.valueOf(projectId) + '_' + "7";
        QFilter qfilters = new QFilter("finterid", "=", (Object)billId);
        qfilters.and("fattachmentpanel", "=", (Object)"attachmentpanel");
        qfilters.and("fbilltype", "=", (Object)"src_scoresuggestion");
        DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])qfilters.toArray());
    }

    protected void updateAptitudeConfig(IFormView view, long projectId) {
        DynamicObject[] rows;
        QFilter configFilter = new QFilter("billid", "=", (Object)projectId);
        configFilter.and("entrystatus", "!=", (Object)"A");
        for (DynamicObject row : rows = BusinessDataServiceHelper.load((String)SrcAptitudeUtils.getAptitudeConfigF7Key(view), (String)"entrystatus", (QFilter[])configFilter.toArray())) {
            row.set("entrystatus", (Object)"A");
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    protected void updateSupplier(IFormView view, long projectId, String entityName) {
        DynamicObject[] rows;
        String fieldName = "isaptpush";
        if (view.getEntityId().equals("src_aptitudeaudit2")) {
            fieldName = "isaptpush2";
        }
        QFilter qFilter = new QFilter("billid", "=", (Object)projectId);
        qFilter.and(fieldName, "=", (Object)"1");
        for (DynamicObject row : rows = BusinessDataServiceHelper.load((String)entityName, (String)fieldName, (QFilter[])qFilter.toArray())) {
            row.set(fieldName, (Object)"0");
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }
}

