/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen.bidopencomm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bidopen.ISrcBidOpenHandler;
import kd.scm.src.common.bidopen.SrcBidOpenContext;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.bidopen.SrcBidOpenUtils;
import kd.scm.src.common.score.SrcScoreFacade;
import kd.scm.src.common.util.SrcAptitudeUtils;
import kd.scm.src.common.util.SrcComponentUtil;

public class SrcBidOpenConfirmHandle
implements ISrcBidOpenHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcBidOpenContext context) {
        this.bidOpenHadle(context);
    }

    protected void bidOpenHadle(SrcBidOpenContext context) {
        boolean isSucced;
        boolean isBidOpenConfig;
        IFormView view = context.getView();
        boolean isNeedPushScoreTask = false;
        long projectId = PdsCommonUtils.object2Long((Object)view.getModel().getDataEntity().getPkValue());
        Map<String, String> bidOpenNameMap = SrcBidOpenFacade.getBidOpenNameMap(view.getModel().getDataEntity());
        String bidopen_open = bidOpenNameMap.get("src_bidopen_open");
        String bidopenpackage = bidOpenNameMap.get("src_bidopenpackage");
        boolean isOpenBySupplier = false;
        if (bidopen_open.equals("src_supplier_open")) {
            isOpenBySupplier = true;
        }
        HashSet<Long> packageIds = new HashSet<Long>(16);
        HashMap<Long, Long> pkg_supMap = new HashMap<Long, Long>(16);
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity().getDynamicObject("srctype"));
        boolean isManualScoreTask = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"ismanualscoretask", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity())));
        QFilter tecFilter = QFilter.fromSerializedString((String)view.getPageCache().get("tecfilter"));
        QFilter bizFilter = QFilter.fromSerializedString((String)view.getPageCache().get("bizfilter"));
        QFilter aptFilter = QFilter.fromSerializedString((String)view.getPageCache().get("aptfilter"));
        String opKey = view.getPageCache().get("opkey");
        Map<String, Object> resultMap = null;
        StringBuilder msgSb = new StringBuilder();
        try (Object h = TX.requiresNew();){
            try {
                resultMap = SrcBidOpenFacade.openBidDoc(opKey, tecFilter, bizFilter, aptFilter);
                if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                    msgSb.append(String.format(ResManager.loadKDString((String)"\u5f00\u6807\u672a\u6210\u529f\uff0c\u539f\u56e0\uff1a%1$s\u3002", (String)"SrcBidOpenConfirmHandle_0", (String)"scm-src-common", (Object[])new Object[0]), resultMap.get("message")));
                    throw new KDBizException(msgSb.toString());
                }
                isNeedPushScoreTask = true;
                if (!opKey.equals("aptopen") && !((Boolean)(resultMap = SrcBidOpenFacade.openPurlist(bizFilter)).get("succed")).booleanValue()) {
                    msgSb.append(String.format(ResManager.loadKDString((String)"\u5f00\u6807\u672a\u6210\u529f\uff0c\u539f\u56e0\uff1a%1$s\u3002", (String)"SrcBidOpenConfirmHandle_0", (String)"scm-src-common", (Object[])new Object[0]), resultMap.get("message")));
                    throw new KDBizException(msgSb.toString());
                }
                this.updateBidOpenStatus(context, bidopen_open, bidopenpackage, isOpenBySupplier, packageIds, pkg_supMap);
            }
            catch (Exception e) {
                msgSb.append(e.getMessage());
                view.showTipNotification(msgSb.toString());
                h.markRollback();
                if (h != null) {
                    if (var22_21 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var22_21.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return;
            }
        }
        if (isOpenBySupplier && packageIds.size() > 0) {
            switch (opKey) {
                case "aptopen": {
                    SrcBidOpenFacade.updatePackageOpenStatus(projectId, packageIds, "isaptopen");
                    break;
                }
                case "tecopen": {
                    SrcBidOpenFacade.updatePackageOpenStatus(projectId, packageIds, "istecopen");
                    break;
                }
                case "bizopen": {
                    SrcBidOpenFacade.updatePackageOpenStatus(projectId, packageIds, "isbizopen");
                    break;
                }
                case "allopen": {
                    SrcBidOpenFacade.updatePackageOpenStatus(projectId, packageIds, "isallopen");
                    break;
                }
            }
        }
        if ((isBidOpenConfig = SrcBidOpenFacade.isBidOpenConfig(view.getModel().getDataEntity(true), opKey)) && isNeedPushScoreTask && (!isManualScoreTask || SrcBidOpenUtils.isOfflineScore(projectId))) {
            if (opKey.equals("aptopen") || SrcBidOpenUtils.isAptitudeAudit2Open(view, opKey)) {
                if (SrcAptitudeUtils.isSupplierReplyAptitude(view.getModel().getDataEntity())) {
                    DynamicObject billObj = view.getModel().getDataEntity();
                    if ("1".equals(billObj.getString("aptitudetype"))) {
                        SrcScoreFacade.sendScoreTaskMessage(billObj, billObj.getDataEntityType().getName(), "pushaptitude");
                    }
                    this.updateScoreTaskStatus(projectId, pkg_supMap);
                } else {
                    SrcAptitudeUtils.pushScoreTask(view, Collections.emptyList());
                }
            } else {
                resultMap = SrcBidOpenFacade.pushScoreTask(view, view.getModel().getDataEntity(), "allopen", Collections.emptyList(), opKey);
            }
        }
        SrcBidOpenFacade.setProjectOpenStatus(projectId);
        SrcBidOpenFacade.synthCalculate(view.getEntityId(), projectId);
        boolean bl = isSucced = null == resultMap.get("succed") ? true : (Boolean)resultMap.get("succed");
        if (isSucced) {
            view.showMessage(ResManager.loadKDString((String)"\u5f00\u6807\u6210\u529f\u3002", (String)"SrcBidOpenConfirmHandle_2", (String)"scm-src-common", (Object[])new Object[0]));
        } else {
            String message = PdsCommonUtils.object2String((Object)resultMap.get("message"), (String)"");
            view.showMessage(ResManager.loadKDString((String)"\u5f00\u6807\u53ca\u4e0b\u8fbe\u8bc4\u6807\u4efb\u52a1\u7ed3\u679c", (String)"SrcBidOpenConfirmHandle_3", (String)"scm-src-common", (Object[])new Object[0]), message, MessageTypes.Default);
        }
        view.invokeOperation("refresh");
    }

    private void updateBidOpenStatus(SrcBidOpenContext context, String bidopen_open, String bidopenpackage, boolean isOpenBySupplier, Set<Long> packageIds, Map<Long, Long> pkg_supMap) {
        DynamicObject compObj = SrcComponentUtil.getComponentObj(context.getView(), bidopen_open);
        if (compObj == null) {
            return;
        }
        long billId = PdsCommonUtils.object2Long((Object)compObj.getPkValue());
        String selectFields = DynamicObjectUtil.getSelectfields((String)bidopenpackage, (boolean)false);
        DynamicObject[] packageObjs = BusinessDataServiceHelper.load((String)bidopenpackage, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)billId)});
        ArrayList<DynamicObject> packageList = new ArrayList<DynamicObject>(packageObjs.length);
        Object[] tempObjs = DynamicObjectSerializeUtil.deserialize((String)context.getView().getPageCache().get("bizobject"), (DynamicObjectType)packageObjs[0].getDynamicObjectType());
        String opKey = context.getView().getPageCache().get("opkey");
        long rankId = SrcBidOpenFacade.getMaxOpenRank(SrmCommonUtil.getPkValue((DynamicObject)context.getView().getModel().getDataEntity()));
        for (Object tempObj : tempObjs) {
            DynamicObject obj = (DynamicObject)tempObj;
            long packId1 = SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("package"));
            long supId1 = this.getSupplierId(isOpenBySupplier, obj);
            for (DynamicObject packageObj : packageObjs) {
                long packId2 = SrmCommonUtil.getPkValue((DynamicObject)packageObj.getDynamicObject("package"));
                long supId2 = this.getSupplierId(isOpenBySupplier, packageObj);
                boolean isOpenUnTenderSupplier = this.isOpenUnTenderSupplier(isOpenBySupplier, packageObj, opKey, packageObj);
                if ((packId1 != packId2 || supId1 != supId2) && !isOpenUnTenderSupplier) continue;
                if ((opKey.equals("allopen") || opKey.equals("tecopen")) && obj.getBoolean("istecopen")) {
                    SrcBidOpenFacade.updateTecOpenStatus(packageObj);
                }
                if ((opKey.equals("allopen") || opKey.equals("bizopen")) && obj.getBoolean("isbizopen")) {
                    SrcBidOpenFacade.updateBizOpenStatus(packageObj);
                }
                if (opKey.equals("aptopen") && obj.getBoolean("isaptopen")) {
                    SrcBidOpenFacade.updateAptOpenStatus(packageObj);
                    pkg_supMap.put(obj.getLong("package.id"), supId1);
                }
                if (isOpenBySupplier) {
                    if (packageObj.getInt("rank") == 0) {
                        SrcBidOpenUtils.updateRank(packageObj, PdsCommonUtils.object2Integer((Object)rankId), context.getView().getEntityId(), compObj.getBoolean("isnoderank"));
                    }
                    packageIds.add(obj.getLong("package.id"));
                }
                packageList.add(packageObj);
            }
        }
        PdsCommonUtils.saveDynamicObjects(packageList);
    }

    public void updateScoreTaskStatus(long projectId, Map<Long, Long> pkg_supMap) {
        if (pkg_supMap.size() == 0) {
            return;
        }
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("bizstatus", "=", (Object)"A");
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_scoretask", (String)"package,supplier,bizstatus", (QFilter[])qfilter.toArray());
        if (rows.length == 0) {
            return;
        }
        ArrayList<DynamicObject> scoreTaskObjs = new ArrayList<DynamicObject>(rows.length);
        for (DynamicObject row : rows) {
            long packageId;
            long l = packageId = row.getLong("package.id") == 0L ? SrmCommonUtil.getPkValue((DynamicObject)PdsCommonUtils.getNoPackageNameObj((long)projectId)) : row.getLong("package.id");
            if (null == pkg_supMap.get(packageId) || pkg_supMap.get(packageId).longValue() != row.getLong("supplier.id") && pkg_supMap.get(packageId) != 0L) continue;
            row.set("bizstatus", (Object)"B");
            scoreTaskObjs.add(row);
        }
        PdsCommonUtils.saveDynamicObjects(scoreTaskObjs);
    }

    private long getSupplierId(boolean isOpenBySupplier, DynamicObject obj) {
        long supplierId = 0L;
        if (isOpenBySupplier) {
            supplierId = SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("supplier"));
        }
        return supplierId;
    }

    private boolean isOpenUnTenderSupplier(boolean isOpenBySupplier, DynamicObject packageObj, String opKey, DynamicObject obj) {
        if (!isOpenBySupplier) {
            return false;
        }
        if (packageObj.getBoolean("istender")) {
            return false;
        }
        if ((opKey.equals("allopen") || opKey.equals("tecopen")) && !packageObj.getBoolean("istecopen")) {
            return true;
        }
        if ((opKey.equals("allopen") || opKey.equals("bizopen")) && !packageObj.getBoolean("isbizopen")) {
            return true;
        }
        return opKey.equals("aptopen") && obj.getBoolean("isaptopen") && !packageObj.getBoolean("isaptopen");
    }
}

