/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen.bidopencomm;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.src.common.bidopen.ISrcBidOpenHandler;
import kd.scm.src.common.bidopen.SrcBidOpenContext;
import org.apache.commons.lang3.StringUtils;

public class SrcBidOpenHideSupplierName
implements ISrcBidOpenHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcBidOpenContext context) {
        this.isHideSupplierName(context);
    }

    protected void isHideSupplierName(SrcBidOpenContext context) {
        String selectFields = "ishidesupplier,scorestatus,openstatus,currentnode.number";
        QFilter qfilter = new QFilter("id", "=", (Object)context.getProjectId());
        DynamicObject billObj = QueryServiceHelper.queryOne((String)"src_scorertask", (String)selectFields, (QFilter[])qfilter.toArray());
        if (null == billObj) {
            context.setHideSupplierName(false);
            return;
        }
        boolean isHideSupplierName = billObj.getBoolean("ishidesupplier");
        if (!isHideSupplierName) {
            context.setHideSupplierName(false);
            return;
        }
        Set<String> conditionSet = this.getConditionSet();
        String scoreStatus = billObj.getString("scorestatus");
        if (conditionSet.contains("1") && this.getScoreStatusSet().contains(scoreStatus)) {
            context.setHideSupplierName(false);
            return;
        }
        String nodeNumber = billObj.getString("currentnode.number");
        if (conditionSet.contains("2") && this.getCurrentNodeNumberSet().contains(nodeNumber)) {
            context.setHideSupplierName(false);
            return;
        }
        String openStatus = billObj.getString("openstatus");
        if (conditionSet.contains("3") && this.getOpenStatusSet().contains(openStatus)) {
            context.setHideSupplierName(false);
            return;
        }
        context.setHideSupplierName(true);
    }

    private Set<String> getConditionSet() {
        Set<String> conditionSet = new HashSet<String>(4);
        String values = (String)ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"showsuppliername");
        if (null != values) {
            conditionSet = Arrays.stream(values.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList()).stream().collect(Collectors.toSet());
        }
        if (conditionSet.size() == 0) {
            conditionSet.add("1");
            conditionSet.add("2");
            conditionSet.add("3");
        }
        return conditionSet;
    }

    private Set<String> getScoreStatusSet() {
        HashSet<String> set = new HashSet<String>(4);
        set.add("C");
        set.add("D");
        return set;
    }

    private Set<String> getCurrentNodeNumberSet() {
        HashSet<String> set = new HashSet<String>(4);
        set.add(PdsBizNodeEnums.PREDECISION.getValue());
        set.add(PdsBizNodeEnums.DECISION.getValue());
        return set;
    }

    private Set<String> getOpenStatusSet() {
        HashSet<String> set = new HashSet<String>(4);
        set.add("9");
        set.add("A");
        set.add("B");
        return set;
    }
}

