/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen.bidopencomm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.entity.PdsObjectPools;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.bidopen.ISrcBidOpenHandler;
import kd.scm.src.common.bidopen.SrcBidOpenContext;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.bidopen.SrcBidOpenUtils;
import kd.scm.src.common.util.SrcAppCache;
import kd.scm.src.common.util.SrcComponentUtil;

public class SrcBidOpenPkgOpenHandle
implements ISrcBidOpenHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcBidOpenContext context) {
        this.packageOpenHandle(context);
    }

    private void packageOpenHandle(SrcBidOpenContext context) {
        IFormView view = context.getView();
        String opKey = context.getOperateKey();
        Map<String, String> bidOpenNameMap = SrcBidOpenFacade.getBidOpenNameMap(view.getModel().getDataEntity());
        String bidopen_open = bidOpenNameMap.get("src_bidopen_open");
        String bidopenpackage = bidOpenNameMap.get("src_bidopenpackage");
        DynamicObject compObj = null;
        if ("src_supplier_open".equals(bidopen_open)) {
            context.setOpenBySupplier(true);
            String compPageId = SrcAppCache.get("src_supplier_open", String.class, view);
            IFormView compView = view.getView(compPageId);
            if (compView != null) {
                compObj = compView.getModel().getDataEntity(true);
            }
        } else {
            compObj = TemplateUtil.getCompData((DynamicObject)view.getModel().getDataEntity(), (String)bidopen_open);
        }
        if (compObj == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f00\u6807\u60c5\u51b5\u4e2d\u6ca1\u6709\u5f85\u5f00\u6807\u7684\u5206\u5f55\uff0c\u4e0d\u80fd\u8fdb\u884c\u5f00\u6807\u5904\u7406\u3002", (String)"SrcBidOpenPkgOpenHandle_0", (String)"scm-src-common", (Object[])new Object[0]));
            return;
        }
        long billId = PdsCommonUtils.object2Long((Object)compObj.getPkValue());
        DynamicObjectCollection rows = compObj.getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f00\u6807\u60c5\u51b5\u4e2d\u6ca1\u6709\u5f85\u5f00\u6807\u7684\u5206\u5f55\uff0c\u4e0d\u80fd\u8fdb\u884c\u5f00\u6807\u5904\u7406\u3002", (String)"SrcBidOpenPkgOpenHandle_0", (String)"scm-src-common", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> tecList = new ArrayList<Long>();
        ArrayList<Long> bizList = new ArrayList<Long>();
        ArrayList<Long> aptList = new ArrayList<Long>();
        ArrayList<Long> supList = new ArrayList<Long>();
        String selectFields = DynamicObjectUtil.getSelectfields((String)bidopenpackage, (boolean)true);
        String opentype = PdsCommonUtils.object2String((Object)compObj.get("opentype"), (String)"1");
        IFormView compView = SrcComponentUtil.getComponentView(view, bidopen_open);
        StringBuilder sb = new StringBuilder();
        List<Integer> selectIndexs = SrcBidOpenUtils.getSelectIndexs(view, null, opKey);
        QFilter packageFilter = this.getPackageFiter(billId, compView, selectIndexs);
        Object[] packageObjs = BusinessDataServiceHelper.load((String)bidopenpackage, (String)selectFields, (QFilter[])packageFilter.toArray());
        block12: for (int i = 0; i < selectIndexs.size(); ++i) {
            DynamicObject row = compView.getModel().getEntryRowEntity("entryentity", selectIndexs.get(i).intValue());
            switch (opKey) {
                case "allopen": {
                    SrcBidOpenFacade.handleTecBid(context, opentype, row, tecList, sb, (DynamicObject[])packageObjs, supList);
                    SrcBidOpenFacade.handleBizBid(context, opentype, row, bizList, sb, (DynamicObject[])packageObjs, supList);
                    continue block12;
                }
                case "tecopen": {
                    SrcBidOpenFacade.handleTecBid(context, opentype, row, tecList, sb, (DynamicObject[])packageObjs, supList);
                    continue block12;
                }
                case "bizopen": {
                    SrcBidOpenFacade.handleBizBid(context, opentype, row, bizList, sb, (DynamicObject[])packageObjs, supList);
                    continue block12;
                }
                case "aptopen": {
                    SrcBidOpenFacade.handleAptBid(context, opentype, row, aptList, sb, (DynamicObject[])packageObjs, supList);
                    continue block12;
                }
            }
        }
        if (tecList != null && tecList.size() > 0 || bizList != null && bizList.size() > 0 || aptList != null && aptList.size() > 0) {
            QFilter tecPkgFilter = new QFilter("package.id", "in", tecList).or("package.id", "=", (Object)0L);
            if (context.isOpenBySupplier()) {
                tecPkgFilter.and("supplier", "in", supList);
            }
            QFilter tecFilter = new QFilter("project.id", "=", compObj.getPkValue()).and("entrystatus", "=", (Object)ProjectStatusEnums.QUOTED.getValue()).and(tecPkgFilter);
            QFilter bizPkgFilter = new QFilter("package.id", "in", bizList).or("package.id", "=", (Object)0L);
            if (context.isOpenBySupplier()) {
                bizPkgFilter.and("supplier", "in", supList);
            }
            QFilter bizFilter = new QFilter("project.id", "=", compObj.getPkValue()).and("entrystatus", "=", (Object)ProjectStatusEnums.QUOTED.getValue()).and(bizPkgFilter);
            view.getPageCache().put("tecfilter", tecFilter.toSerializedString());
            view.getPageCache().put("bizfilter", bizFilter.toSerializedString());
            QFilter aptPkgFilter = new QFilter("package.id", "in", aptList).or("package.id", "=", (Object)0L);
            if (context.isOpenBySupplier()) {
                aptPkgFilter.and("supplier", "in", supList);
            }
            QFilter aptFilter = new QFilter("project.id", "=", compObj.getPkValue()).and("entrystatus", "=", (Object)ProjectStatusEnums.QUOTED.getValue()).and(aptPkgFilter);
            view.getPageCache().put("aptfilter", aptFilter.toSerializedString());
            HashSet<Long> selectPackageIds = new HashSet<Long>();
            selectPackageIds.addAll(tecList);
            selectPackageIds.addAll(bizList);
            selectPackageIds.addAll(aptList);
            String key = String.valueOf(billId) + '_' + view.getEntityId() + '_' + "packageid";
            PdsObjectPools.putInstance((String)key, selectPackageIds);
            view.getPageCache().put("opkey", opKey);
            view.getPageCache().put("bizobject", DynamicObjectSerializeUtil.serialize((Object[])packageObjs, (DynamicObjectType)packageObjs[0].getDynamicObjectType()));
            if (!context.isOpenBySupplier()) {
                sb.append("\n").append((CharSequence)SrcBidOpenFacade.getBidOpenTipMessage(compObj).getMessage());
            }
            String title = ResManager.loadKDString((String)"\u5f00\u6807\u76f8\u5173\u4fe1\u606f\u5982\u4e0b\uff0c\u662f\u5426\u7ee7\u7eed\u5f00\u6807\uff1f", (String)"SrcBidOpenPkgOpenHandle_4", (String)"scm-src-common", (Object[])new Object[0]);
            view.showConfirm(title, String.format(ResManager.loadKDString((String)"%1$s", (String)"SrcBidOpenPkgOpenHandle_5", (String)"scm-src-common", (Object[])new Object[0]), sb), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("confirmActionId"));
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u5f00\u6807\u8bb0\u5f55(\u6240\u6709\u8bb0\u5f55\u5747\u5df2\u5f00\u6807\uff0c\u6216\u672a\u5f00\u6280\u672f\u6807/\u672a\u8bc4\u6280\u672f\u6807)\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"SrcBidOpenPkgOpenHandle_3", (String)"scm-src-common", (Object[])new Object[0]));
        }
    }

    private QFilter getPackageFiter(long billId, IFormView compView, List<Integer> selectIndexs) {
        HashSet<Long> idSet = new HashSet<Long>(selectIndexs.size());
        for (int i = 0; i < selectIndexs.size(); ++i) {
            DynamicObject row = compView.getModel().getEntryRowEntity("entryentity", selectIndexs.get(i).intValue());
            if (compView.getEntityId().equals("src_supplier_open")) {
                idSet.add(row.getLong("srcentryid"));
                continue;
            }
            idSet.add(SrmCommonUtil.getPkValue((DynamicObject)row));
        }
        QFilter qfilter = new QFilter("billid", "=", (Object)billId);
        qfilter.and("id", "in", idSet);
        return qfilter;
    }
}

