/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen.bidopencomm;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.enums.ProjectScoreTypeEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bidopen.ISrcBidOpenHandler;
import kd.scm.src.common.bidopen.SrcBidOpenContext;
import kd.scm.src.common.score.push.SrcScoreTaskFacade;
import kd.scm.src.common.util.SrcBidAssessUtils;
import kd.scm.src.common.util.SrcPurListUtil;

public class SrcBidOpenPushBtnVisible
implements ISrcBidOpenHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcBidOpenContext context) {
        this.setPushButtonVisible(context);
    }

    protected void setPushButtonVisible(SrcBidOpenContext context) {
        DynamicObject billObj = context.getView().getModel().getDataEntity();
        if (!PdsCommonUtils.isSaveStatus((DynamicObject)billObj)) {
            context.getView().setVisible(Boolean.FALSE, new String[]{"bar_push"});
            return;
        }
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)billObj);
        String scoreType = billObj.getString("projectf7.scoretype");
        if (Objects.equals(scoreType, ProjectScoreTypeEnums.OFFLINE.getValue())) {
            QFilter cfgFilter = new QFilter("billid", "=", (Object)projectId);
            cfgFilter.and("scheme", ">", (Object)0);
            if (!QueryServiceHelper.exists((String)"src_bidopenconfig", (QFilter[])cfgFilter.toArray())) {
                context.getView().setVisible(Boolean.FALSE, new String[]{"bar_push"});
                context.getView().setVisible(Boolean.FALSE, new String[]{"bar_score"});
                return;
            }
        }
        QFilter qFilter = new QFilter("billid", "=", (Object)projectId);
        qFilter.and("package", "in", SrcPurListUtil.getValidPackageIds(projectId));
        if (SrcBidAssessUtils.isParallelOpenTec(billObj)) {
            qFilter.and("indextype.basetype", "!=", (Object)"2");
            qFilter.and("package.istecopen", "=", (Object)"1");
            context.getView().setVisible(Boolean.FALSE, new String[]{"repushscore"});
        } else if (SrcBidAssessUtils.isParallelOpenBiz(billObj)) {
            qFilter.and("indextype.basetype", "=", (Object)"2");
            qFilter.and("package.isbizopen", "=", (Object)"1");
            context.getView().setVisible(Boolean.FALSE, new String[]{"repushscore"});
            if (!billObj.getBoolean("isbizscore")) {
                context.getView().setVisible(Boolean.FALSE, new String[]{"bar_push"});
                return;
            }
        } else {
            qFilter.and("package.istecopen", "=", (Object)"1");
            if ("src_bidassess".equals(billObj.getDataEntityType().getName())) {
                qFilter.and("indextype.basetype", "!=", (Object)"2");
            } else if ("src_compare".equals(billObj.getDataEntityType().getName())) {
                qFilter.and("package.isbizopen", "=", (Object)"1");
                qFilter.and("indextype.basetype", "=", (Object)"2");
                if (!billObj.getBoolean("isbizscore")) {
                    context.getView().setVisible(Boolean.FALSE, new String[]{"bar_push"});
                    return;
                }
            }
        }
        QFilter configFilter = new QFilter("entrystatus", "=", (Object)ProcessStatusEnums.NOTSTARTED.getValue()).and(qFilter);
        if (QueryServiceHelper.exists((String)"src_bidopenconfig", (QFilter[])configFilter.toArray())) {
            context.getView().setVisible(Boolean.TRUE, new String[]{"bar_push"});
        } else if (QueryServiceHelper.exists((String)"src_bidopenconfig", (QFilter[])qFilter.toArray()) && SrcScoreTaskFacade.isExistsUnPushSupplier(billObj)) {
            context.getView().setVisible(Boolean.TRUE, new String[]{"bar_push"});
        } else {
            context.getView().setVisible(Boolean.FALSE, new String[]{"bar_push"});
        }
    }
}

