/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen.bidopencomm;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.src.common.bidopen.ISrcBidOpenHandler;
import kd.scm.src.common.bidopen.SrcBidOpenContext;

public class SrcBidOpenTecHandle
implements ISrcBidOpenHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcBidOpenContext context) {
        this.handleTecBid(context);
    }

    protected void handleTecBid(SrcBidOpenContext context) {
        IFormView view = context.getView();
        String openType = context.getOpenType();
        DynamicObject row = context.getRow();
        List<Long> tecList = context.getTecList();
        List<Long> supList = context.getSupList();
        StringBuilder sb = context.getSb();
        DynamicObject[] packageObjs = context.getPackageObjs();
        if (null != openType) {
            if (openType.trim().length() == 0) {
                openType = "1";
            }
            switch (openType) {
                case "1": {
                    if (row.getBoolean("istecopen")) break;
                    this.setTecBid(context, view, row, tecList, sb, packageObjs, supList);
                    break;
                }
                case "2": 
                case "4": {
                    if (row.getBoolean("istecopen")) break;
                    this.setTecBid(context, view, row, tecList, sb, packageObjs, supList);
                    break;
                }
                case "3": {
                    if (!row.getBoolean("isbizopen") || row.getBoolean("istecopen")) break;
                    this.setTecBid(context, view, row, tecList, sb, packageObjs, supList);
                    break;
                }
            }
        }
    }

    protected void setTecBid(SrcBidOpenContext context, IFormView view, DynamicObject row, List<Long> tecList, StringBuilder sb, DynamicObject[] packageObjs, List<Long> supList) {
        boolean isNeedOpenTec = false;
        DynamicObjectCollection flowRows = view.getModel().getDataEntity(true).getDynamicObjectCollection("entrymainflow");
        for (DynamicObject flowRow : flowRows) {
            String node = flowRow.getString("biznode.number");
            if (!PdsBizNodeEnums.BIDASSESS.getValue().equals(node) && !PdsBizNodeEnums.SCORERTASK.getValue().equals(node)) continue;
            isNeedOpenTec = true;
            break;
        }
        for (DynamicObject packageObj : packageObjs) {
            Object pkId;
            Object object = pkId = context.isOpenBySupplier() ? Long.valueOf(row.getLong("srcentryid")) : row.getPkValue();
            if (!packageObj.getPkValue().equals(pkId)) continue;
            packageObj.set("istecopen", (Object)"1");
            packageObj.set("tecopendate", (Object)TimeServiceHelper.now());
            packageObj.set("tecopenuser", (Object)RequestContext.get().getCurrUserId());
            if (row.getDynamicObject("package") == null) continue;
            if (isNeedOpenTec) {
                if (context.isOpenBySupplier()) {
                    if ("2".equals(view.getModel().getValue("managetype"))) {
                        sb.append(String.format(ResManager.loadKDString((String)"\u6807\u6bb5(%1$s)\u7684\u4f9b\u5e94\u5546(%2$s)\u5c06\u5f00\u6280\u672f\u6807\u3002", (String)"SrcBidOpenTecHandle_4", (String)"scm-src-common", (Object[])new Object[0]), row.getString("package.packagename"), row.getString("supplier.name")));
                    } else {
                        sb.append(String.format(ResManager.loadKDString((String)"\u9879\u76ee(%1$s)\u7684\u4f9b\u5e94\u5546(%2$s)\u5c06\u5f00\u6280\u672f\u6807\u3002", (String)"SrcBidOpenTecHandle_5", (String)"scm-src-common", (Object[])new Object[0]), view.getModel().getDataEntity().getString("bidname"), row.getString("supplier.name")));
                    }
                } else if (((Boolean)view.getModel().getValue("ismultipackage")).booleanValue()) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u6807\u6bb5(%1$s)\u5c06\u5f00\u6280\u672f\u6807,", (String)"SrcBidOpenTecHandle_0", (String)"scm-src-common", (Object[])new Object[0]), row.getString("package.packagename")));
                } else {
                    sb.append(String.format(ResManager.loadKDString((String)"\u9879\u76ee(%1$s)\u5c06\u5f00\u6280\u672f\u6807,", (String)"SrcBidOpenTecHandle_1", (String)"scm-src-common", (Object[])new Object[0]), view.getModel().getDataEntity().getString("bidname")));
                }
            }
            tecList.add(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("package")));
            if (!context.isOpenBySupplier()) continue;
            supList.add(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("supplier")));
        }
    }
}

