/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bizquery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bizquery.ISrcReferPriceHandler;

public class SrcHistoryPriceHandler
implements ISrcReferPriceHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        Map<Long, DynamicObject> historyPurlistMap;
        Map<Long, List<DynamicObject>> purlistMap = this.getUpdatePurlistRows(context);
        if (purlistMap.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> purlistList = new ArrayList<DynamicObject>();
        long currentyId = PdsCommonUtils.object2Long(context.getParamMap().get("currency"));
        QFilter qfilters = this.getHistoryPurlistFilter(purlistMap.keySet(), currentyId, 24);
        Map<Long, DynamicObject> lastPurlistMap = this.getHistoryPurlistRows(qfilters, "lastprice", "1");
        if (lastPurlistMap.size() > 0) {
            this.setOptimalPrice(purlistMap, purlistList, lastPurlistMap, "price12", "price13");
        }
        if ((historyPurlistMap = this.getHistoryPurlistRows(qfilters, "optimalprice", "1")).size() > 0) {
            this.setOptimalPrice(purlistMap, purlistList, historyPurlistMap, "price14", "price15");
        }
    }

    public Map<Long, List<DynamicObject>> getUpdatePurlistRows(ExtPluginContext context) {
        DynamicObject[] rows = context.getRows();
        String fieldName = this.getMaterialIdField(context);
        return Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getLong(fieldName)));
    }
}

