/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bizurge;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.enums.SrcVieStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.src.common.bizurge.ISrcBizUrgeHandler;
import kd.scm.src.common.bizurge.SrcBizUrgeUtils;

public class SrcBizUrgeSupplierVie
implements ISrcBizUrgeHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void queryUrgeMessage(ExtPluginContext context) {
        context.setEntityId("tnd_quotebill");
        long sourceTypeId = context.getProjectObj().getLong("sourcetype.id");
        if (SourceTypeEnums.VIE.getId() != sourceTypeId && SourceTypeEnums.ELECTRONIC_AUCTION.getId() != sourceTypeId) {
            context.setVerifyOk(false);
            return;
        }
        if (!SrcVieStatusEnums.BIDDING.getValue().equals(context.getProjectObj().getString("bidstatus"))) {
            context.setVerifyOk(false);
            return;
        }
        String turns = PdsVieHelper.getLastNegTurns((DynamicObject)PdsVieHelper.getLastNegTurnsObj((long)context.getProjectId()));
        String vieTurns = PdsVieHelper.getLastVieTurns((long)context.getProjectId(), (String)turns);
        QFilter vieFilter = new QFilter("project", "=", (Object)context.getProjectId());
        vieFilter.and("turns", "=", (Object)turns);
        vieFilter.and("vieturns", "=", (Object)vieTurns);
        vieFilter.and("opkey", "=", (Object)"initial");
        DynamicObject[] vieRows = BusinessDataServiceHelper.load((String)"pds_bizoperatelog", (String)"supplier", (QFilter[])vieFilter.toArray());
        HashSet supplierSet = new HashSet();
        for (DynamicObject vieRow : vieRows) {
            supplierSet.addAll(MultiBasedataUtils.getBasedataIdSet((DynamicObject)vieRow, (String)"supplier"));
        }
        QFilter quoteFilter = new QFilter("project", "=", (Object)context.getProjectId());
        quoteFilter.and("turns", "=", (Object)turns);
        quoteFilter.and("supplier", "not in", supplierSet);
        DynamicObject[] quoteRows = PdsCommonUtils.loadBillObjsByQFilter((String)"tnd_quotebill", (QFilter)quoteFilter);
        context.setRows(quoteRows);
        if (null == context.getRows() || context.getRows().length == 0) {
            context.setVerifyOk(false);
            return;
        }
        SrcBizUrgeUtils.buildQueryResult(context, "supplier.id", "supplier.name");
    }

    @Override
    public void queryUrgePlanTime(ExtPluginContext context) {
        if (null != context.getRows() && context.getRows().length > 0) {
            ((Map)context.getParamMap2().get("fieldid")).put("begindate", context.getRows()[0].get("createtime"));
            ((Map)context.getParamMap2().get("fieldid")).put("enddate", context.getRows()[0].get("deadline"));
        }
    }

    @Override
    public void sendUrgeMessage(ExtPluginContext context) {
        context.setOperationKey("urgemessage");
        SrcBizUrgeUtils.sendUrgeMessage(context);
    }
}

