/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bizurge;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bizurge.ISrcBizUrgeHandler;
import kd.scm.src.common.bizurge.SrcBusinessQueryInit;

public class SrcBizUrgeUtils {
    public static void getBizUrgeBillObjs(ExtPluginContext context) {
        QFilter qfilter = SchemeFilterUtils.getQFilterByExtFilterScheme((String)context.getEntityId(), (String)(context.getEntityId() + context.getSubfix() + '_' + "bizurge"), (DynamicObject)context.getProjectObj(), null);
        if (null == qfilter) {
            return;
        }
        context.setRows(PdsCommonUtils.loadBillObjsByQFilter((String)context.getEntityId(), (QFilter)qfilter));
    }

    public static void sendUrgeMessage(ExtPluginContext context) {
        if (null == context.getRows() || context.getRows().length == 0) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("entityId", context.getEntityId());
        OperationServiceHelper.executeOperate((String)context.getOperationKey(), (String)context.getEntityId(), (DynamicObject[])context.getRows(), (OperateOption)option);
    }

    public static DynamicObjectCollection getExtPluginNames(String opKey) {
        QFilter qfilter = new QFilter("number", "=", (Object)opKey);
        qfilter.and("status", "=", (Object)BillStatusEnum.AUDIT.getVal());
        qfilter.and("enable", "=", (Object)"1");
        String selectfields = "id,order,number,name,pluginname";
        return QueryServiceHelper.query((String)"pds_extplugin", (String)selectfields, (QFilter[])new QFilter[]{qfilter}, (String)"order");
    }

    public static ExtPluginContext bizUrgeQueryAndSend(DynamicObject projectObj, long extPluginId, String extPluginName, boolean isSendMessage) {
        ExtPluginContext context = new ExtPluginContext();
        HashMap fieldMap = new HashMap(8);
        context.getParamMap2().put("fieldid", fieldMap);
        context.setProjectObj(projectObj);
        context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)projectObj));
        context.setBillId(extPluginId);
        context.setSendMessage(isSendMessage);
        ISrcBizUrgeHandler hander = (ISrcBizUrgeHandler)ExtPluginFactory.getInstance().getExtPluginInstanceSingle(extPluginName);
        hander.process(context);
        return context;
    }

    public static void groupQueryResult(ExtPluginContext context, String idField, String nameField) {
        Map<Long, DynamicObject> groupMap = Arrays.asList(context.getRows()).stream().collect(Collectors.groupingBy(e -> e.getLong(idField), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        int index = 0;
        DynamicObject[] groupRows = new DynamicObject[groupMap.size()];
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Long, DynamicObject> entry : groupMap.entrySet()) {
            groupRows[index++] = entry.getValue();
            sb.append(entry.getValue().getString(nameField)).append(',');
        }
        context.setMessage(sb.toString().substring(0, sb.length() - 1));
        context.setRows(groupRows);
        ((Map)context.getParamMap2().get("fieldid")).put("count", context.getRows().length);
    }

    public static void buildQueryResult(ExtPluginContext context, String idField, String nameField) {
        StringBuilder sb = new StringBuilder();
        for (DynamicObject row : context.getRows()) {
            sb.append(row.getString(nameField)).append(',');
        }
        context.setMessage(sb.toString().substring(0, sb.length() - 1));
        ((Map)context.getParamMap2().get("fieldid")).put("count", context.getRows().length);
    }

    public static void buildQueryResult(ExtPluginContext context, String multiField) {
        StringBuilder sb = new StringBuilder();
        for (DynamicObject row : context.getRows()) {
            DynamicObjectCollection subRows = row.getDynamicObjectCollection(multiField);
            for (DynamicObject subRow : subRows) {
                sb.append(subRow.getString("fbasedataid.name")).append(',');
            }
        }
        context.setMessage(sb.toString().substring(0, sb.length() - 1));
        ((Map)context.getParamMap2().get("fieldid")).put("count", context.getRows().length);
    }

    public static DynamicObjectCollection getNoticeSuppliers(long projectId) {
        QFilter qfilter = new QFilter("srcbillid", "=", (Object)projectId);
        qfilter.and("entitykey", "=", (Object)"src_sourcenotice");
        qfilter.and("biztype", "in", (Object)PdsCommonUtils.buildSet((String[])new String[]{"2", "C"}));
        qfilter.and("supscope", "=", (Object)"2");
        qfilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        DynamicObject[] compObjs = PdsCommonUtils.loadBillObjsByQFilter((String)"src_sourcenotice", (QFilter)qfilter);
        if (null == compObjs || compObjs.length == 0) {
            return null;
        }
        return compObjs[0].getDynamicObjectCollection("entryentity");
    }

    public static Set<Long> getEnrollSupplierIds(long projectId) {
        QFilter qfilters = new QFilter("billid", "=", (Object)projectId);
        DynamicObjectCollection enrollRows = QueryServiceHelper.query((String)"src_enrollsupplier", (String)"supplier.id", (QFilter[])qfilters.toArray());
        return enrollRows.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
    }

    public static void businessQuery(IFormView view, Map<String, Object> paramMap, DynamicObject billObj) {
        String operateKey = PdsCommonUtils.object2String((Object)paramMap.get("opkey"), (String)"");
        String[] operateKeys = operateKey.split("\\|");
        if (!"businessquery".equals(operateKeys[0])) {
            return;
        }
        QFilter qfilters = new QFilter("number", "=", (Object)operateKey);
        if (QueryServiceHelper.exists((String)"pds_extplugin", (QFilter[])qfilters.toArray())) {
            ExtPluginContext context = new ExtPluginContext();
            context.setView(view);
            context.setBillObj(billObj);
            context.setProjectObj(billObj);
            context.setProjectId(PdsCommonUtils.object2Long((Object)paramMap.get("projectid")));
            context.setOperationKey(operateKey);
            if (operateKeys.length > 1) {
                context.setEntityId(operateKeys[1]);
            }
            ExtPluginFactory.executeExtplugin((String)operateKey, (ExtPluginContext)context, (boolean)true);
            if (null != context.getMessage() && context.getMessage().length() > 0) {
                view.showMessage(ResManager.loadKDString((String)"\u4e1a\u52a1\u67e5\u8be2\u7ed3\u679c", (String)"SrcBizUrgeUtils_0", (String)"scm-src-common", (Object[])new Object[0]), context.getMessage().toString(), MessageTypes.Default);
            }
            return;
        }
        if (operateKeys.length > 1) {
            try {
                ExtPluginContext context = SrcBizUrgeUtils.initContext(view, paramMap, billObj);
                String entityName = context.getEntityId();
                qfilters = context.getQfilters();
                Set noFilterEntitySet = context.getCompKeys();
                if (null == qfilters || !QueryServiceHelper.exists((String)entityName, (QFilter[])qfilters.toArray())) {
                    if (noFilterEntitySet.contains(entityName)) {
                        OpenFormUtils.openListPage((IFormView)view, (String)entityName, (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)qfilters, null);
                    } else {
                        view.showTipNotification(ResManager.loadKDString((String)"\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55\u3002", (String)"SrcBizUrgeUtils_1", (String)"scm-src-common", (Object[])new Object[0]));
                    }
                } else {
                    OpenFormUtils.openListPage((IFormView)view, (String)entityName, (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)qfilters, null);
                }
            }
            catch (Exception e) {
                view.showTipNotification(ResManager.loadKDString((String)"\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55\u3002", (String)"SrcBizUrgeUtils_1", (String)"scm-src-common", (Object[])new Object[0]));
            }
            return;
        }
    }

    public static ExtPluginContext initContext(IFormView view, Map<String, Object> paramMap, DynamicObject billObj) {
        String operateKey = PdsCommonUtils.object2String((Object)paramMap.get("opkey"), (String)"");
        String[] operateKeys = operateKey.split("\\|");
        ExtPluginContext context = new ExtPluginContext();
        context.setBillObj(billObj);
        context.setEntityId(operateKeys[1]);
        ExtPluginFactory.executeExtplugin((String)SrcBusinessQueryInit.class.getSimpleName(), (ExtPluginContext)context, (boolean)true, (String)SrcBusinessQueryInit.class.getName());
        return context;
    }

    public static void businessUrge(IFormView view, Map<String, Object> paramMap, DynamicObject billObj) {
        String operateKey = PdsCommonUtils.object2String((Object)paramMap.get("opkey"), (String)"");
        String[] operateKeys = operateKey.split("\\|");
        if (!"businessurge".equals(operateKeys[0])) {
            return;
        }
        OpenFormUtils.openDynamicPage((IFormView)view, (String)operateKeys[1], (ShowType)ShowType.MainNewTabPage, paramMap, null, null);
    }

    public static void conformQuery(IFormView view, Map<String, Object> paramMap, DynamicObject billObj) {
        String operateKey = PdsCommonUtils.object2String((Object)paramMap.get("opkey"), (String)"");
        String[] operateKeys = operateKey.split("\\|");
        if (!"conformquery".equals(operateKeys[0])) {
            return;
        }
        OpenFormUtils.openDynamicPage((IFormView)view, (String)operateKeys[1], (ShowType)ShowType.MainNewTabPage, paramMap, null, null);
    }
}

