/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.extfilter.ExtFilterContext;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcExchangeRateUtils;
import kd.scm.src.common.calc.ISrcCalculate;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcLocalAmount;
import kd.scm.src.common.calc.SrcGlobalCalcContext;
import kd.scm.src.common.calc.rank.ISrcRankSorter;
import kd.scm.src.common.calc.rank.SrcRankFacade;
import kd.scm.src.common.calc.rank.SrcRankSortByValueAndTime;
import kd.scm.src.common.calc.ratio.SrcRatioFacade;
import kd.scm.src.common.calc.total.SrcTotalFacade;
import kd.scm.src.common.calc.verify.ISrcSynthCalcVerify;

public class SrcCalcHelper {
    public static void synthCalcVerify(long projectId, SrcGlobalCalcContext globalContext) {
        if (globalContext.getIsAllowSynthCalc() >= 0) {
            return;
        }
        ExtPluginContext context = new ExtPluginContext();
        context.setProjectId(projectId);
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)context.getProjectId(), (String)"src_project");
        context.setProjectObj(projectObj);
        ExtPluginFactory.executeExtplugin((String)ISrcSynthCalcVerify.class.getSimpleName(), (ExtPluginContext)context, (boolean)false);
        if (context.isSucced()) {
            globalContext.setIsAllowSynthCalc(1);
        } else {
            globalContext.setIsAllowSynthCalc(0);
            globalContext.getCustomMap().put("message", context.getMessage());
            globalContext.setMessage(context.getMessage());
            globalContext.setSucced(false);
        }
    }

    public static SrcGlobalCalcContext syntheticalCalculate(String entityId, long projectId) {
        SrcGlobalCalcContext globalContext = new SrcGlobalCalcContext();
        SrcRankFacade.getInstance().calculate(entityId, projectId, globalContext, Boolean.TRUE);
        SrcRatioFacade.getInstance().calculate(entityId, projectId, globalContext, Boolean.FALSE);
        SrcTotalFacade.getInstance().calculate(entityId, projectId, globalContext, Boolean.FALSE);
        return globalContext;
    }

    public static SrcCalcContext createContext(String entityName, long billId, SrcGlobalCalcContext globalContext, boolean isResetPurlist) {
        SrcCalcContext context = SrcCalcHelper.getContextInstance();
        context.setGlobalContext(globalContext == null ? new SrcGlobalCalcContext() : globalContext);
        context.setEntityName(entityName);
        context.setBillId(billId);
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"src_project");
        context.setProjectObj(projectObj);
        context.setResetPurlist(isResetPurlist);
        context.setSourcetype(projectObj.getString("sourcetype.number"));
        SrcCalcHelper.SetLocCurrencyAndExTableID(context);
        context.setIndex(1);
        context.setPackageFilter(null);
        return context;
    }

    public static SrcCalcContext getContextInstance() {
        return (SrcCalcContext)ExtPluginFactory.getInstance().getExtPluginInstance(SrcCalcContext.class.getSimpleName(), SrcCalcContext.class.getName());
    }

    public static SrcCalcLocalAmount getCalcLocalAmountInstance() {
        return (SrcCalcLocalAmount)ExtPluginFactory.getInstance().getExtPluginInstance(SrcCalcLocalAmount.class.getSimpleName(), SrcCalcLocalAmount.class.getName());
    }

    public static void SetLocCurrencyAndExTableID(SrcCalcContext context) {
        context.setLocCurrencyId(context.getProjectObj().getLong("currency.id"));
        context.setExchangeTableID(SrcExchangeRateUtils.getRateTableIdByOrg((long)context.getProjectObj().getLong("org.id")));
    }

    public static void getAllProjectIds(List<Long> billIds) {
        DynamicObjectCollection projectObjs = QueryServiceHelper.query((String)"src_decisionsum_pro", (String)"entryentity.project.id", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        for (DynamicObject projectObj : projectObjs) {
            billIds.add(projectObj.getLong("entryentity.project.id"));
        }
    }

    public static long getFirstValue(Map<String, Long> map) {
        Map.Entry<String, Long> entry;
        long value = 0L;
        Iterator<Map.Entry<String, Long>> iterator = map.entrySet().iterator();
        while (iterator.hasNext() && (value = (entry = iterator.next()).getValue().longValue()) <= 0L) {
        }
        return value;
    }

    public static long getTmpSupplierId(String supplierName) {
        QFilter qFilter = new QFilter("name", "=", (Object)supplierName);
        DynamicObject tempObj = QueryServiceHelper.queryOne((String)"src_supplier_tmp", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (tempObj != null) {
            return tempObj.getLong("id");
        }
        DynamicObject supObj = BusinessDataServiceHelper.newDynamicObject((String)"src_supplier_tmp");
        ORMUtil.setPrimaryKey((DynamicObject)supObj);
        String number = CodeRuleServiceHelper.getNumber((String)"src_supplier_tmp", (DynamicObject)supObj, null);
        supObj.set("number", (Object)number);
        supObj.set("name", (Object)supplierName);
        supObj.set("status", (Object)BillStatusEnum.AUDIT.getVal());
        supObj.set("enable", (Object)"1");
        supObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        supObj.set("createtime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{supObj});
        return (Long)supObj.getPkValue();
    }

    public static Map<String, Object> getRatioObjectIdFromKey(String key) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        String[] splitKey = key.split("\\|");
        resultMap.put("supplierid", Long.parseLong(splitKey[0]));
        resultMap.put("projectid", Long.parseLong(splitKey[1]));
        resultMap.put("packageid", Long.parseLong(splitKey[2]));
        resultMap.put("categoryid", Long.parseLong(splitKey[3]));
        return resultMap;
    }

    public static Map<String, BigDecimal> getRatioAmount(SrcCalcContext context, DynamicObject purlistObj) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(16);
        resultMap.put("amount", BigDecimal.ZERO);
        resultMap.put("taxamount", BigDecimal.ZERO);
        resultMap.put("locamount", BigDecimal.ZERO);
        resultMap.put("loctaxamount", BigDecimal.ZERO);
        resultMap.put("locamount2", BigDecimal.ZERO);
        resultMap.put("loctaxamount2", BigDecimal.ZERO);
        resultMap.put("result", BigDecimal.ZERO);
        if (purlistObj == null) {
            return resultMap;
        }
        boolean isByDecision = PdsCommonUtils.object2Boolean((Object)context.getGlobalContext().getCustomMap().get("isbydecision"));
        if (isByDecision) {
            SrcCalcHelper.calcAmountByDecisionAmount(context, resultMap, purlistObj);
        } else if (context.getRatioType().equals("9")) {
            SrcCalcHelper.calcAmountByCfmQty(context, resultMap, purlistObj);
        } else {
            SrcCalcHelper.calcAmountByRatio(context, resultMap, purlistObj);
        }
        return resultMap;
    }

    private static void calcAmountByDecisionAmount(SrcCalcContext context, Map<String, BigDecimal> resultMap, DynamicObject purlistObj) {
        BigDecimal decisionAmount = purlistObj.getBigDecimal("price4");
        BigDecimal decisionTaxamount = purlistObj.getBigDecimal("price5");
        BigDecimal decisionLocAmount = purlistObj.getBigDecimal("price6");
        BigDecimal decisionLocTaxAmount = purlistObj.getBigDecimal("price7");
        BigDecimal locAmount = purlistObj.getBigDecimal("locamount");
        BigDecimal locTaxAmount = purlistObj.getBigDecimal("loctaxamount");
        if (context.getOrderRatioResults().contains(purlistObj.getString("result"))) {
            resultMap.put("amount", decisionAmount);
            resultMap.put("taxamount", decisionTaxamount);
            resultMap.put("locamount", decisionLocAmount);
            resultMap.put("loctaxamount", decisionLocTaxAmount);
            resultMap.put("result", BigDecimal.ONE);
        }
        resultMap.put("locamount2", locAmount);
        resultMap.put("loctaxamount2", locTaxAmount);
    }

    private static void calcAmountByRatio(SrcCalcContext context, Map<String, BigDecimal> resultMap, DynamicObject purlistObj) {
        BigDecimal orderRatio = purlistObj.getBigDecimal("orderratio").divide(BigDecimal.TEN).divide(BigDecimal.TEN);
        BigDecimal amount = purlistObj.getBigDecimal("amount");
        BigDecimal taxamount = purlistObj.getBigDecimal("taxamount");
        BigDecimal locAmount = purlistObj.getBigDecimal("locamount");
        BigDecimal locTaxAmount = purlistObj.getBigDecimal("loctaxamount");
        int precision = SrcCalcHelper.getPrecision(purlistObj, "currency");
        int locPrecision = SrcCalcHelper.getPrecision(purlistObj, "loccurr");
        if (context.getOrderRatioResults().contains(purlistObj.getString("result"))) {
            resultMap.put("amount", orderRatio.multiply(amount).setScale(precision, RoundingMode.HALF_UP));
            resultMap.put("taxamount", orderRatio.multiply(taxamount).setScale(precision, RoundingMode.HALF_UP));
            resultMap.put("locamount", orderRatio.multiply(locAmount).setScale(locPrecision, RoundingMode.HALF_UP));
            resultMap.put("loctaxamount", orderRatio.multiply(locTaxAmount).setScale(locPrecision, RoundingMode.HALF_UP));
            resultMap.put("result", BigDecimal.ONE);
        }
        resultMap.put("locamount2", locAmount.setScale(locPrecision, RoundingMode.HALF_UP));
        resultMap.put("loctaxamount2", locTaxAmount.setScale(locPrecision, RoundingMode.HALF_UP));
    }

    private static void calcAmountByCfmQty(SrcCalcContext context, Map<String, BigDecimal> resultMap, DynamicObject purlistObj) {
        BigDecimal ratio = SrcCalcHelper.getQtyRatio(purlistObj);
        int precision = SrcCalcHelper.getPrecision(purlistObj, "currency");
        int locPrecision = SrcCalcHelper.getPrecision(purlistObj, "loccurr");
        if (context.getOrderRatioResults().contains(purlistObj.getString("result"))) {
            resultMap.put("amount", ratio.multiply(purlistObj.getBigDecimal("amount")).setScale(precision, RoundingMode.HALF_UP));
            resultMap.put("taxamount", ratio.multiply(purlistObj.getBigDecimal("taxamount")).setScale(precision, RoundingMode.HALF_UP));
            resultMap.put("locamount", ratio.multiply(purlistObj.getBigDecimal("locamount")).setScale(locPrecision, RoundingMode.HALF_UP));
            resultMap.put("loctaxamount", ratio.multiply(purlistObj.getBigDecimal("loctaxamount")).setScale(locPrecision, RoundingMode.HALF_UP));
            resultMap.put("result", BigDecimal.ONE);
        }
        resultMap.put("locamount2", purlistObj.getBigDecimal("locamount"));
        resultMap.put("loctaxamount2", purlistObj.getBigDecimal("loctaxamount"));
    }

    public static BigDecimal getBizAmount(String valueField, DynamicObject purlistObj) {
        BigDecimal bizamount = BigDecimal.ZERO;
        if (purlistObj == null) {
            return BigDecimal.ZERO;
        }
        if (valueField == null || "".equals(valueField.trim())) {
            return BigDecimal.ZERO;
        }
        try {
            String sourceType;
            bizamount = purlistObj.getBigDecimal(valueField);
            if (bizamount.compareTo(BigDecimal.ZERO) <= 0 && ((sourceType = purlistObj.getString("project.sourcetype.number")).equals(SourceTypeEnums.VIE.getValue()) || sourceType.equals(SourceTypeEnums.ELECTRONIC_AUCTION.getValue()))) {
                bizamount = purlistObj.getBigDecimal("vieamount");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bizamount;
    }

    public static DynamicObject[] sortByValueAndTime(SrcCalcContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ISrcRankSorter.class.getSimpleName(), SrcRankSortByValueAndTime.class.getName());
        DynamicObject[] array = context.getAssessList().toArray(new DynamicObject[0]);
        context.setAssessArray(array);
        for (ISrcRankSorter handler : handlers) {
            handler.process(context);
        }
        return context.getAssessArray();
    }

    public static DynamicObject[] sortByRandom(SrcCalcContext context) {
        List<DynamicObject> objList = context.getAssessList();
        if (null == objList || objList.size() == 0) {
            return new DynamicObject[0];
        }
        Collections.shuffle(objList);
        return objList.toArray(new DynamicObject[0]);
    }

    public static Map<String, BigDecimal> getTecAndBizAndOthScore(SrcCalcContext context) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(16);
        String key = null;
        String bizKey = null;
        String tecKey = null;
        String key1 = null;
        String key2 = null;
        if (context.getSupplierId() > 0L) {
            key1 = String.valueOf(context.getSupplierId());
        }
        if (context.getPackageId() > 0L) {
            key2 = String.valueOf(context.getPackageId());
        }
        boolean flag = (context.getSumType().equals("2") || context.getSumType().equals("3")) && key2 != null;
        key = flag ? key1 + "|" + key2 : key1;
        tecKey = context.isPushTecByPurlist() ? key + "|" + String.valueOf(context.getPurlistId()) : key;
        resultMap.put("tecscore", context.getTecScoreMap() == null || context.getTecScoreMap().get(tecKey) == null ? BigDecimal.ZERO : context.getTecScoreMap().get(tecKey));
        resultMap.put("othscore", context.getOthScoreMap() == null || context.getOthScoreMap().get(tecKey) == null ? BigDecimal.ZERO : context.getOthScoreMap().get(tecKey));
        bizKey = context.isPushBizByPurlist() ? key + "|" + String.valueOf(context.getPurlistId()) : key;
        if (context.getScoretype().equals("2")) {
            resultMap.put("bizscore", context.getBizScoreMap() == null || context.getBizScoreMap().get(bizKey) == null ? BigDecimal.ZERO : context.getBizScoreMap().get(bizKey));
        } else {
            SrcCalcHelper.getBizScoreMap(context, resultMap);
        }
        return resultMap;
    }

    private static void getBizScoreMap(SrcCalcContext context, Map<String, BigDecimal> resultMap) {
        if (!context.isBizScore()) {
            return;
        }
        String key = null;
        String key1 = null;
        String key2 = null;
        if (context.getSupplierId() > 0L) {
            key1 = String.valueOf(context.getSupplierId());
        }
        switch (context.getSumType()) {
            case "1": {
                if (context.getSupplierId() <= 0L) break;
                key2 = String.valueOf(context.getProjectObj().getPkValue());
                break;
            }
            case "2": {
                if (context.getPackageId() <= 0L) break;
                key2 = String.valueOf(context.getPackageId());
                break;
            }
            case "3": {
                List purlistObjs = Arrays.asList(context.getPurlistObjs()).stream().filter(e -> e.getLong("id") == context.getPurlistId()).collect(Collectors.toList());
                key2 = String.valueOf(context.getPackageId()) + '|' + ((DynamicObject)purlistObjs.get(0)).getString("purlist.id");
                break;
            }
        }
        key = key1 + "|" + key2;
        BigDecimal bizScore = context.getBizScoreMap() == null || context.getBizScoreMap().get(key) == null ? BigDecimal.ZERO : context.getBizScoreMap().get(key);
        resultMap.put("bizscore", bizScore);
        if (resultMap.get("bizscore").compareTo(BigDecimal.ZERO) == 0) {
            key = key1 + "|" + String.valueOf(context.getPackageId()) + "|" + String.valueOf(context.getPurlistId());
            resultMap.put("bizscore", context.getBizScoreMap() == null || context.getBizScoreMap().get(key) == null ? BigDecimal.ZERO : context.getBizScoreMap().get(key));
        }
        if (resultMap.get("bizscore").compareTo(BigDecimal.ZERO) == 0) {
            key = key1 + "|" + String.valueOf(context.getPackageId());
            resultMap.put("bizscore", context.getBizScoreMap() == null || context.getBizScoreMap().get(key) == null ? BigDecimal.ZERO : context.getBizScoreMap().get(key));
        }
        if (resultMap.get("bizscore").compareTo(BigDecimal.ZERO) == 0) {
            key = key1;
            resultMap.put("bizscore", context.getBizScoreMap() == null || context.getBizScoreMap().get(key) == null ? BigDecimal.ZERO : context.getBizScoreMap().get(key));
        }
    }

    public static Map<String, Object> getRankObjectIdFromKey(String sumType, String key) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("supplierid", 0L);
        resultMap.put("packageid", 0L);
        resultMap.put("purlistid", 0L);
        String[] splitKey = key.split("\\|");
        switch (sumType) {
            case "1": {
                if (splitKey[0] == null || splitKey[0].length() <= 0) break;
                resultMap.put("supplierid", Long.parseLong(splitKey[0]));
                break;
            }
            case "2": {
                if (splitKey[0] != null && splitKey[0].length() > 0) {
                    resultMap.put("supplierid", Long.parseLong(splitKey[0]));
                }
                if (splitKey[1] == null || splitKey[1].length() <= 0) break;
                resultMap.put("packageid", Long.parseLong(splitKey[1]));
                break;
            }
            case "3": {
                if (splitKey[0] != null && splitKey[0].length() > 0) {
                    resultMap.put("supplierid", splitKey[0]);
                }
                if (splitKey[1] != null && splitKey[1].length() > 0) {
                    resultMap.put("packageid", Long.parseLong(splitKey[1]));
                }
                if (splitKey[2] == null || splitKey[2].length() <= 0) break;
                resultMap.put("purlistid", Long.parseLong(splitKey[2]));
                break;
            }
        }
        return resultMap;
    }

    public static void executeCalcPlugin(String number, SrcCalcContext context, boolean isFailContinue) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(number, null);
        for (ISrcCalculate handler : handlers) {
            if (!isFailContinue && !context.isSucced()) continue;
            handler.process(context);
        }
    }

    public static int getPrecision(DynamicObject purlistObj, String currField) {
        DynamicObject curr = purlistObj.getDynamicObject(currField);
        int precision = null == curr ? 4 : curr.getInt("amtprecision");
        return precision;
    }

    public static BigDecimal getOrderRatio(DynamicObject purlistObj) {
        BigDecimal orderRatio = purlistObj.getBigDecimal("orderratio");
        return orderRatio.divide(BigDecimal.TEN).divide(BigDecimal.TEN);
    }

    public static BigDecimal getQtyRatio(DynamicObject purlistObj) {
        BigDecimal qty = purlistObj.getBigDecimal("qty");
        BigDecimal cfmQty = purlistObj.getBigDecimal("cfmqty");
        if (qty.compareTo(BigDecimal.ZERO) > 0) {
            return cfmQty.divide(qty, 10, RoundingMode.HALF_DOWN);
        }
        return BigDecimal.ONE;
    }

    public static ExtFilterContext convertContext(SrcCalcContext context) {
        ExtFilterContext extContext = new ExtFilterContext();
        extContext.setProjectObj(context.getProjectObj());
        if (null != context.getBillObjs() && context.getBillObjs().length > 0) {
            extContext.setBillObj(context.getBillObjs()[0]);
        }
        return extContext;
    }
}

