/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.SrcExchangeRateUtils;
import kd.scm.src.common.calc.ISrcCalculate;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcGetPurlist;

public class SrcCalcLocalAmount
implements ISrcCalculate {
    @Override
    public void process(SrcCalcContext context) {
        if (context.getGlobalContext().isCalcLocalAmt()) {
            return;
        }
        this.calcLocalPriceAndAmount(context);
        if (null != context.getPurlistObjs() && context.getPurlistObjs().length > 0) {
            SaveServiceHelper.save((DynamicObject[])context.getPurlistObjs());
            SrcCalcGetPurlist handler = new SrcCalcGetPurlist();
            handler.process(context);
        }
        context.getGlobalContext().setCalcLocalAmt(Boolean.TRUE);
    }

    public void calcLocalPriceAndAmount(SrcCalcContext context) {
        DynamicObject[] purlistObjs = context.getPurlistObjs();
        if (purlistObjs == null || purlistObjs.length == 0) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        for (DynamicObject purlistObj : purlistObjs) {
            this.calcLocalPriceAndAmount(purlistObj, context.getLocCurrencyId(), paramMap);
        }
    }

    public void calcLocalPriceAndAmount(DynamicObject purlistObj, long locCurrencyId, Map<String, Object> paramMap) {
        long supCurrencyId = SrmCommonUtil.getPkValue((DynamicObject)purlistObj.getDynamicObject("currency"));
        if (supCurrencyId == 0L) {
            supCurrencyId = locCurrencyId;
            purlistObj.set("currency_id", (Object)supCurrencyId);
        }
        purlistObj.set("loccurr_id", (Object)locCurrencyId);
        StringBuilder currMsgSb = new StringBuilder();
        HashMap cacheMap = new HashMap(8);
        SrcExchangeRateUtils.getExchangeRate((DynamicObject)purlistObj, (StringBuilder)currMsgSb, cacheMap);
        SrcExchangeRateUtils.setCalcLocalValue((DynamicObject)purlistObj, (String)"price", (String)"locprice", (String)"priceprecision");
        SrcExchangeRateUtils.setCalcLocalValue((DynamicObject)purlistObj, (String)"taxprice", (String)"loctaxprice", (String)"priceprecision");
        SrcExchangeRateUtils.setCalcLocalValue((DynamicObject)purlistObj, (String)"amount", (String)"locamount", (String)"amtprecision");
        SrcExchangeRateUtils.setCalcLocalValue((DynamicObject)purlistObj, (String)"taxamount", (String)"loctaxamount", (String)"amtprecision");
    }
}

