/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.rank.ISrcRankProcess;

public class SrcRankCalcBizScore
implements ISrcRankProcess {
    @Override
    public void process(SrcCalcContext context) {
        if (!context.isBizScore()) {
            return;
        }
        this.calcManualBizScore(context);
    }

    protected void calcManualBizScore(SrcCalcContext context) {
        QFilter qFilter = new QFilter("index.billid", "=", (Object)context.getBillId());
        qFilter.and("scored", "=", (Object)"1");
        qFilter.and("billid.indextype.basetype", "=", (Object)"2");
        qFilter.and("billid.bizstatus", "=", (Object)"D");
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_scoretask_indexf7", (String)"billid,index,manscore,finalscore", (QFilter[])new QFilter[]{qFilter});
        if (rows == null || rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            boolean flag;
            String key = null;
            String keySupplier = null;
            String keyPackage = null;
            String keyOther = null;
            keySupplier = String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("billid.supplier")));
            if (row.getDynamicObject("billid.package") != null) {
                keyPackage = String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("billid.package")));
            }
            boolean bl = flag = (Objects.equals(context.getSumType(), "2") || Objects.equals(context.getSumType(), "3")) && keyPackage != null;
            if (flag) {
                keySupplier = keySupplier + "|" + keyPackage;
            }
            keyOther = String.valueOf(row.getLong("index.srcentryid"));
            key = keySupplier + "|" + keyOther;
            BigDecimal sumScore = row.getBigDecimal("finalscore");
            if (context.getBizScoreMap() == null) {
                context.setBizScoreMap(new HashMap<String, BigDecimal>(16));
            }
            if (context.getBizScoreMap().get(key) == null) {
                context.getBizScoreMap().put(key, sumScore);
                continue;
            }
            context.getBizScoreMap().put(key, sumScore.add(context.getBizScoreMap().get(key)));
        }
    }
}

