/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Map;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.calc.rank.ISrcRankCoreCalc;
import kd.scm.src.common.calc.rank.SrcRankFacade;

public class SrcRankCalcMaxMinAvg
implements ISrcRankCoreCalc {
    @Override
    public void process(SrcCalcContext context) {
        this.calcMaxMinAvgValue(context);
    }

    protected void calcMaxMinAvgValue(SrcCalcContext context) {
        Map<String, Object> groupIdMap = SrcCalcHelper.getRankObjectIdFromKey(context.getSumType(), context.getCurrGKey());
        long groupPackageId = PdsCommonUtils.object2Long((Object)groupIdMap.get("packageid"));
        long groupPurlistId = PdsCommonUtils.object2Long((Object)groupIdMap.get("purlistid"));
        BigDecimal minValue = BigDecimal.valueOf(999999999L);
        BigDecimal maxValue = BigDecimal.ZERO;
        BigDecimal sumValue = BigDecimal.ZERO;
        BigDecimal avgValue = BigDecimal.ZERO;
        BigDecimal avgBaseValue = BigDecimal.ZERO;
        BigDecimal sumBaseValue = BigDecimal.ZERO;
        boolean isLargeZero = null != context.getValueField() && context.isLargeZero();
        ArrayList<BigDecimal> bizScoreList = new ArrayList<BigDecimal>(8);
        for (String key : context.getRankValueMap().keySet()) {
            boolean isAvgByQty;
            String[] splitKey;
            Map<String, Object> idMap = SrcCalcHelper.getRankObjectIdFromKey(context.getSumType(), key);
            String supplierId = String.valueOf(idMap.get("supplierid"));
            long packageId = PdsCommonUtils.object2Long((Object)idMap.get("packageid"));
            long purlistId = PdsCommonUtils.object2Long((Object)idMap.get("purlistid"));
            if (context.getSumType().equals("2") ? packageId != groupPackageId : context.getSumType().equals("3") && (packageId != groupPackageId || purlistId != groupPurlistId || (splitKey = supplierId.split("\\_")).length == 2 && context.getPresentSet().contains(Long.parseLong(splitKey[1])))) continue;
            BigDecimal bizAmount = context.getRankValueMap().get(key);
            if (isLargeZero && bizAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal qty = context.getRankQtyMap().get(key);
            int rows = context.getRankCountMap().get(key);
            boolean isAvgByRow = rows > 0 && context.getAvgType().equals("2");
            boolean bl = isAvgByQty = qty.compareTo(BigDecimal.ZERO) > 0 && context.getAvgType().equals("3");
            if (isAvgByRow) {
                bizAmount = bizAmount.divide(BigDecimal.valueOf(rows), 6);
                context.getRankValueMap().put(key, bizAmount);
            } else if (isAvgByQty) {
                bizAmount = bizAmount.divide(qty, 6);
                context.getRankValueMap().put(key, bizAmount);
            }
            if (bizAmount.compareTo(minValue) < 0) {
                minValue = bizAmount;
            }
            if (bizAmount.compareTo(maxValue) > 0) {
                maxValue = bizAmount;
            }
            bizScoreList.add(bizAmount);
            sumValue = sumValue.add(bizAmount);
            sumBaseValue = sumBaseValue.add(context.getRankBaseMap().get(key));
        }
        if (minValue.compareTo(BigDecimal.ZERO) <= 0) {
            minValue = new BigDecimal("0.0000001");
        } else if (minValue.compareTo(BigDecimal.valueOf(999999999L)) == 0) {
            minValue = new BigDecimal("0.0000001");
        }
        avgValue = SrcRankFacade.calcAverageValue(context, bizScoreList, sumValue);
        avgBaseValue = bizScoreList.size() == 0 ? sumBaseValue.divide(BigDecimal.ONE, 6, RoundingMode.HALF_DOWN) : sumBaseValue.divide(new BigDecimal(bizScoreList.size()), 6, RoundingMode.HALF_DOWN);
        context.setMaxValue(maxValue);
        context.setMinValue(minValue);
        context.setAvgValue(avgValue);
        context.setSumValue(sumValue);
        context.setBaseValue(avgBaseValue);
    }
}

