/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.rank.ISrcRankProcess;

public class SrcRankCalcTecScore
implements ISrcRankProcess {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        this.calcTecScoreAndOthScore(context);
    }

    protected void calcTecScoreAndOthScore(SrcCalcContext context) {
        DynamicObject[] rows;
        QFilter qFilter = new QFilter("project.id", "=", (Object)context.getBillId());
        qFilter.and("bizstatus", "=", (Object)"D");
        if (context.getPackageFilter() != null) {
            qFilter.and(context.getPackageFilter());
        }
        if ((rows = BusinessDataServiceHelper.load((String)"src_scoretask", (String)"supplier,suppliertype,package,purlist,indextype,sumscore", (QFilter[])new QFilter[]{qFilter})) == null || rows.length == 0) {
            return;
        }
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj().getDynamicObject("srctype"));
        boolean isPushTecByPurlist = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isPushTecScoreTaskByPurlist", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj())));
        context.setPushTecByPurlist(isPushTecByPurlist);
        boolean isPushBizByPurlist = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isPushBizScoreTaskByPurlist", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj())));
        context.setPushBizByPurlist(isPushBizByPurlist);
        block10: for (DynamicObject row : rows) {
            String key = null;
            String tecKey = null;
            String bizKey = null;
            String key1 = null;
            String key2 = null;
            String baseType = row.getDynamicObject("indextype").getString("basetype");
            key1 = String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("supplier")));
            if (row.getDynamicObject("package") != null) {
                key2 = String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("package")));
            }
            BigDecimal sumScore = row.getBigDecimal("sumscore");
            boolean flag = (Objects.equals(context.getSumType(), "2") || Objects.equals(context.getSumType(), "3")) && key2 != null;
            key = flag ? key1 + "|" + key2 : key1;
            tecKey = context.isPushTecByPurlist() ? key + "|" + String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("purlist"))) : key;
            bizKey = context.isPushTecByPurlist() ? key + "|" + String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("purlist"))) : key;
            switch (baseType) {
                case "1": {
                    if (context.getTecScoreMap() == null) {
                        context.setTecScoreMap(new HashMap<String, BigDecimal>(16));
                    }
                    if (context.getTecScoreMap().get(tecKey) == null) {
                        context.getTecScoreMap().put(tecKey, sumScore);
                        continue block10;
                    }
                    context.getTecScoreMap().put(tecKey, sumScore.add(context.getTecScoreMap().get(tecKey)));
                    continue block10;
                }
                case "3": {
                    if (context.getOthScoreMap() == null) {
                        context.setOthScoreMap(new HashMap<String, BigDecimal>(16));
                    }
                    if (context.getOthScoreMap().get(tecKey) == null) {
                        context.getOthScoreMap().put(tecKey, sumScore);
                        continue block10;
                    }
                    context.getOthScoreMap().put(tecKey, sumScore.add(context.getOthScoreMap().get(tecKey)));
                    continue block10;
                }
                case "2": {
                    if (context.getBizScoreMap() == null) {
                        context.setBizScoreMap(new HashMap<String, BigDecimal>(16));
                    }
                    if (context.getBizScoreMap().get(bizKey) == null) {
                        context.getBizScoreMap().put(bizKey, sumScore);
                        continue block10;
                    }
                    context.getBizScoreMap().put(bizKey, sumScore.add(context.getBizScoreMap().get(bizKey)));
                    continue block10;
                }
            }
        }
    }
}

