/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.calc.rank.ISrcRankProcess;

public class SrcRankGroupPurlist
implements ISrcRankProcess {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        this.groupPurlistForRank(context);
    }

    protected void groupPurlistForRank(SrcCalcContext context) {
        if (context.getPurlistObjs() == null) {
            return;
        }
        HashSet<Long> presentSet = new HashSet<Long>();
        for (DynamicObject purlistObj : context.getPurlistObjs()) {
            DynamicObject supplierObj = purlistObj.getDynamicObject("supplier");
            DynamicObject packageObj = purlistObj.getDynamicObject("package");
            DynamicObject listObj = purlistObj.getDynamicObject("purlist");
            String key1 = null;
            String key2 = null;
            String key3 = null;
            String entryId = String.valueOf(purlistObj.getPkValue());
            key1 = supplierObj != null ? String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)supplierObj)) : "0";
            if (packageObj != null) {
                key2 = String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)packageObj));
            }
            if (listObj != null) {
                key3 = String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)listObj));
            }
            BigDecimal bizAmount = SrcCalcHelper.getBizAmount(context.getValueField(), purlistObj);
            this.calcBizAmount(context, key1, key2, key3, bizAmount, purlistObj.getInt("price_uom"));
            String key = this.setRankGKeySet(context, key1, key2, key3, entryId);
            if ("2".equals(context.getProjectObj().getString("taxtype"))) {
                if ("2".equals(context.getProjectObj().getString("decisiontype"))) {
                    this.addAmountAndRowsByKey(context, key, bizAmount, purlistObj.getBigDecimal("qty"), purlistObj.getBigDecimal("maxamount"));
                } else {
                    this.addAmountAndRowsByKey(context, key, bizAmount, purlistObj.getBigDecimal("qty"), purlistObj.getBigDecimal("maxprice"));
                }
            } else if ("2".equals(context.getProjectObj().getString("decisiontype"))) {
                this.addAmountAndRowsByKey(context, key, bizAmount, purlistObj.getBigDecimal("qty"), purlistObj.getBigDecimal("maxtaxamount"));
            } else {
                this.addAmountAndRowsByKey(context, key, bizAmount, purlistObj.getBigDecimal("qty"), purlistObj.getBigDecimal("maxtaxprice"));
            }
            if ("2".equals(context.getPresentRankType()) || !purlistObj.getBoolean("ispresent")) continue;
            presentSet.add(SrmCommonUtil.getPkValue((DynamicObject)purlistObj));
        }
        context.setPresentSet(presentSet);
    }

    protected void calcBizAmount(SrcCalcContext context, String key1, String key2, String key3, BigDecimal bizAmount, int price_uom) {
        BigDecimal ratio = BigDecimal.ONE;
        if (key2 != null && context.getRatioMap() != null && context.getRatioMap().get(key2) != null && context.getRatioMap().get(key2).compareTo(BigDecimal.ZERO) > 0) {
            ratio = context.getRatioMap().get(key2);
            bizAmount = bizAmount.multiply(ratio);
        }
        ratio = BigDecimal.ONE;
        if (key3 != null && context.getRatioMap() != null && context.getRatioMap().get(key3) != null && context.getRatioMap().get(key3).compareTo(BigDecimal.ZERO) > 0) {
            ratio = context.getRatioMap().get(key3);
            bizAmount = bizAmount.multiply(ratio);
        }
        BigDecimal weight = BigDecimal.ONE;
        if (key2 != null && context.getWeightMap() != null && context.getWeightMap().get(key2) != null && context.getWeightMap().get(key2).compareTo(BigDecimal.ZERO) > 0) {
            weight = context.getWeightMap().get(key2);
            bizAmount = bizAmount.multiply(weight);
        }
        weight = BigDecimal.ONE;
        if (key3 != null && context.getWeightMap() != null && context.getWeightMap().get(key3) != null && context.getWeightMap().get(key3).compareTo(BigDecimal.ZERO) > 0) {
            weight = context.getWeightMap().get(key3);
            bizAmount = bizAmount.multiply(weight);
        }
        if ((context.getAvgType().equals("3") || context.getAvgType().equals("2")) && (context.getValueField().equals("locprice") || context.getValueField().equals("loctaxprice")) && price_uom > 0) {
            bizAmount = bizAmount.divide(BigDecimal.valueOf(price_uom), 6);
        }
    }

    protected String setRankGKeySet(SrcCalcContext context, String key1, String key2, String key3, String entryId) {
        if (context.getRankGKeySet() == null) {
            context.setRankGKeySet(new HashSet<String>());
        }
        String key = null;
        switch (context.getSumType()) {
            case "1": {
                if (key1 == null) break;
                key = key1;
                context.getRankGKeySet().add(String.valueOf(context.getBillId()));
                break;
            }
            case "2": {
                if (key1 == null || key2 == null) break;
                key = key1 + "|" + key2;
                context.getRankGKeySet().add(String.valueOf(context.getBillId()) + "|" + key2);
                break;
            }
            case "3": {
                if (key1 == null || key2 == null || key3 == null) break;
                key = key1 + "_" + entryId + "|" + key2 + "|" + key3;
                context.getRankGKeySet().add(String.valueOf(context.getBillId()) + "|" + key2 + "|" + key3);
                break;
            }
            default: {
                if (key1 == null) break;
                key = key1;
                context.getRankGKeySet().add(String.valueOf(context.getBillId()));
            }
        }
        return key;
    }

    protected void addAmountAndRowsByKey(SrcCalcContext context, String key, BigDecimal bizAmount, BigDecimal qty, BigDecimal basePrice) {
        if (key == null) {
            return;
        }
        if (context.getRankValueMap() == null) {
            HashMap<String, BigDecimal> rankValueMap = new HashMap<String, BigDecimal>(16);
            rankValueMap.put(key, bizAmount);
            context.setRankValueMap(rankValueMap);
        } else {
            BigDecimal amount = context.getRankValueMap().get(key) == null ? BigDecimal.ZERO : context.getRankValueMap().get(key);
            context.getRankValueMap().put(key, bizAmount.add(amount));
        }
        if (context.getRankBaseMap() == null) {
            HashMap<String, BigDecimal> rankBaseMap = new HashMap<String, BigDecimal>(16);
            rankBaseMap.put(key, basePrice);
            context.setRankBaseMap(rankBaseMap);
        } else {
            BigDecimal baseValue = context.getRankBaseMap().get(key) == null ? BigDecimal.ZERO : context.getRankBaseMap().get(key);
            context.getRankBaseMap().put(key, baseValue.add(basePrice));
        }
        if (context.getRankCountMap() == null) {
            HashMap<String, Integer> rankCountMap = new HashMap<String, Integer>(16);
            rankCountMap.put(key, 1);
            context.setRankCountMap(rankCountMap);
        } else {
            int count = context.getRankCountMap().get(key) == null ? 0 : context.getRankCountMap().get(key);
            context.getRankCountMap().put(key, count + 1);
        }
        if (context.getRankQtyMap() == null) {
            HashMap<String, BigDecimal> rankQtyMap = new HashMap<String, BigDecimal>(16);
            rankQtyMap.put(key, qty);
            context.setRankQtyMap(rankQtyMap);
        } else {
            BigDecimal quantity = context.getRankQtyMap().get(key) == null ? BigDecimal.ZERO : context.getRankQtyMap().get(key);
            context.getRankQtyMap().put(key, qty.add(quantity));
        }
    }
}

