/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.rank.ISrcRankResult;

public class SrcRankHandleClarifyPrice
implements ISrcRankResult {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        Object isProcessed = context.getGlobalContext().getCustomMap().get(SrcRankHandleClarifyPrice.class.getSimpleName());
        if (null != isProcessed && isProcessed.toString().equals("1")) {
            return;
        }
        DynamicObject[] rows = this.getUpdatePurlistRows(context);
        if (rows.length == 0) {
            return;
        }
        ArrayList<DynamicObject> purlistList = new ArrayList<DynamicObject>();
        Map<Long, DynamicObject> firstMap = this.getFirstRows(context, this.getFirstFilter(context));
        Map<Long, DynamicObject> clarifyMap = this.getClarifyRows(context, this.getClarifyFilter(context));
        if (firstMap.size() > 0 || clarifyMap.size() > 0) {
            this.setFirstAndClarifyPrice(rows, purlistList, firstMap, clarifyMap);
        }
        PdsCommonUtils.saveDynamicObjects(purlistList);
        context.getGlobalContext().getCustomMap().put(SrcRankHandleClarifyPrice.class.getSimpleName(), "1");
    }

    private void setFirstAndClarifyPrice(DynamicObject[] rows, List<DynamicObject> purlistList, Map<Long, DynamicObject> firstMap, Map<Long, DynamicObject> clarifyMap) {
        for (DynamicObject row : rows) {
            DynamicObject clarifyObj;
            boolean isChanged = false;
            DynamicObject firstObj = firstMap.get(row.getLong("id"));
            if (null != firstObj) {
                this.setFirstValue(row, firstObj, "price");
                this.setFirstValue(row, firstObj, "taxprice");
                this.setFirstValue(row, firstObj, "amount");
                this.setFirstValue(row, firstObj, "taxamount");
                isChanged = true;
            }
            if (null != (clarifyObj = clarifyMap.get(row.getLong("id")))) {
                row.set("clarifyprice", (Object)clarifyObj.getBigDecimal("entryentity.price_new"));
                row.set("clarifytaxprice", (Object)clarifyObj.getBigDecimal("entryentity.taxprice_new"));
                row.set("clarifyamount", (Object)clarifyObj.getBigDecimal("entryentity.amount_new"));
                row.set("clarifytaxamount", (Object)clarifyObj.getBigDecimal("entryentity.taxamount_new"));
                isChanged = true;
            }
            if (!isChanged) continue;
            purlistList.add(row);
        }
    }

    private QFilter getFirstFilter(SrcCalcContext context) {
        QFilter qfilters = new QFilter("project", "=", context.getProjectObj().getPkValue());
        qfilters.and("supplier", ">", (Object)0);
        qfilters.and(ExtFilterUtils.getStringFilter((String)"turns", (String)"1"));
        return qfilters;
    }

    private Map<Long, DynamicObject> getFirstRows(SrcCalcContext context, QFilter qfilters) {
        String selectFields = "id,price,taxprice,amount,taxamount,firstprice,firsttaxprice,firstamount,firsttaxamount";
        String orderby = "id";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)selectFields, (QFilter[])qfilters.toArray(), (String)orderby);
        return rows.stream().collect(Collectors.groupingBy(e -> e.getLong("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
    }

    private QFilter getClarifyFilter(SrcCalcContext context) {
        QFilter qfilters = new QFilter("project", "=", context.getProjectObj().getPkValue());
        qfilters.and("billstatus", "=", (Object)"C");
        qfilters.and("isclarify", "=", (Object)"1");
        qfilters.and("entryentity.isnew", "=", (Object)"1");
        qfilters.and(new QFilter("entryentity.price_new", ">", (Object)BigDecimal.ZERO).or("entryentity.taxprice_new", ">", (Object)BigDecimal.ZERO).or("entryentity.amount_new", ">", (Object)BigDecimal.ZERO).or("entryentity.taxamount_new", ">", (Object)BigDecimal.ZERO));
        return qfilters;
    }

    private Map<Long, DynamicObject> getClarifyRows(SrcCalcContext context, QFilter qfilters) {
        String selectFields = "auditdate,entryentity.srcentryid,entryentity.price_new,entryentity.taxprice_new,entryentity.amount_new,entryentity.taxamount_new";
        String orderby = "entryentity.srcentryid,auditdate desc";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"tnd_question", (String)selectFields, (QFilter[])qfilters.toArray(), (String)orderby);
        return rows.stream().collect(Collectors.groupingBy(e -> e.getLong("entryentity.srcentryid"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
    }

    private QFilter getProjectPurlistFilter(SrcCalcContext context) {
        QFilter qfilters = new QFilter("project", "=", context.getProjectObj().getPkValue());
        qfilters.and("entrystatus", ">=", (Object)ProjectStatusEnums.OPENED.getValue());
        qfilters.and("supplier", ">", (Object)0L);
        return qfilters;
    }

    private DynamicObject[] getUpdatePurlistRows(SrcCalcContext context) {
        String selectFields = "firstprice,firsttaxprice,firstamount,firsttaxamount,clarifyprice,clarifytaxprice,clarifyamount,clarifytaxamount";
        QFilter qfilters = this.getProjectPurlistFilter(context);
        return BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])qfilters.toArray());
    }

    private void setFirstValue(DynamicObject row, DynamicObject firstObj, String fieldName) {
        if (firstObj.getBigDecimal("first" + fieldName).compareTo(BigDecimal.ZERO) > 0) {
            // empty if block
        }
        row.set("first" + fieldName, (Object)firstObj.getBigDecimal(fieldName));
    }
}

