/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsDefaultConfigUtil;
import kd.scm.pds.common.util.SrcDateUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.rank.ISrcRankResult;

public class SrcRankHandleHistoryPrice
implements ISrcRankResult {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        Map<Long, DynamicObject> historyPurlistMap;
        Object isProcessed = context.getGlobalContext().getCustomMap().get(SrcRankHandleHistoryPrice.class.getSimpleName());
        if (null != isProcessed && isProcessed.toString().equals("1")) {
            return;
        }
        Map<Long, List<DynamicObject>> purlistMap = this.getUpdatePurlistRows(context);
        if (purlistMap.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> purlistList = new ArrayList<DynamicObject>();
        QFilter qfilters = this.getHistoryPurlistFilter(context, purlistMap);
        Map<Long, DynamicObject> lastPurlistMap = this.getHistoryPurlistRows(context, qfilters, "lastprice");
        if (lastPurlistMap.size() > 0) {
            this.setOptimalPrice(context, purlistMap, purlistList, lastPurlistMap, "price12", "price13");
        }
        if ((historyPurlistMap = this.getHistoryPurlistRows(context, qfilters, "optimalprice")).size() > 0) {
            this.setOptimalPrice(context, purlistMap, purlistList, historyPurlistMap, "price14", "price15");
        }
        PdsCommonUtils.saveDynamicObjects(purlistList);
        context.getGlobalContext().getCustomMap().put(SrcRankHandleHistoryPrice.class.getSimpleName(), "1");
    }

    private void setOptimalPrice(SrcCalcContext context, Map<Long, List<DynamicObject>> purlistMap, List<DynamicObject> purlistList, Map<Long, DynamicObject> optimalPurlistMap, String price, String taxprice) {
        for (Map.Entry<Long, List<DynamicObject>> entry : purlistMap.entrySet()) {
            DynamicObject optimalPurlist = optimalPurlistMap.get(entry.getKey());
            if (null == optimalPurlist) continue;
            for (DynamicObject row : entry.getValue()) {
                row.set(price, (Object)optimalPurlist.getBigDecimal("locprice"));
                row.set(taxprice, (Object)optimalPurlist.getBigDecimal("loctaxprice"));
            }
            purlistList.addAll((Collection<DynamicObject>)entry.getValue());
        }
    }

    private Map<Long, DynamicObject> getHistoryPurlistRows(SrcCalcContext context, QFilter qfilters, String orderType) {
        String selectFields = "material.id,category.id,locprice,loctaxprice";
        String orderby = " material";
        orderby = "optimalprice".equals(orderType) ? ("2".equals(context.getRankCalcType()) ? orderby + ", locprice desc, loctaxprice desc" : orderby + ", locprice, loctaxprice") : orderby + ", billid.createtime desc";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_contractentry", (String)selectFields, (QFilter[])qfilters.toArray(), (String)orderby);
        return rows.stream().collect(Collectors.groupingBy(e -> e.getLong("material.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
    }

    private QFilter getHistoryPurlistFilter(SrcCalcContext context, Map<Long, List<DynamicObject>> purlistMap) {
        QFilter projectFilter = new QFilter("id", "=", context.getProjectObj().getPkValue());
        DynamicObject baseObj = QueryServiceHelper.queryOne((String)"src_project_base", (String)"currency.id, monthnum", (QFilter[])projectFilter.toArray());
        long currencyId = baseObj.getLong("currency.id");
        int monthnum = baseObj.getInt("monthnum");
        if (monthnum == 0) {
            monthnum = Integer.parseInt(PdsDefaultConfigUtil.getDefaultValue((DynamicObject)baseObj, (String)"src_project", (String)"src_project_base", (String)"monthnum", (Object)12).toString());
        }
        Date historyDate = SrcDateUtils.getDateByOffsetDay((Date)TimeServiceHelper.now(), (int)(-monthnum * 30));
        QFilter qfilters = new QFilter("material", "in", purlistMap.keySet());
        qfilters.and("loccurr", "=", (Object)currencyId);
        qfilters.and("billid.createtime", ">=", (Object)historyDate);
        qfilters.and("material", ">", (Object)0L);
        qfilters.and(new QFilter("locprice", ">", (Object)BigDecimal.ZERO).or("loctaxprice", ">", (Object)BigDecimal.ZERO));
        return qfilters;
    }

    private Map<Long, List<DynamicObject>> getUpdatePurlistRows(SrcCalcContext context) {
        String selectFields = "material,category,price12,price13,price14,price15";
        QFilter qfilters = this.getProjectPurlistFilter(context);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])qfilters.toArray());
        return Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getLong("material.id")));
    }

    private QFilter getProjectPurlistFilter(SrcCalcContext context) {
        QFilter qfilters = new QFilter("project", "=", context.getProjectObj().getPkValue());
        qfilters.and("entrystatus", "in", this.getStatusSet());
        qfilters.and("material", ">", (Object)0L);
        return qfilters;
    }

    private Set<String> getStatusSet() {
        HashSet<String> statusSet = new HashSet<String>(4);
        statusSet.add(ProjectStatusEnums.OPENED.getValue());
        statusSet.add(ProjectStatusEnums.CLOSED.getValue());
        return statusSet;
    }
}

