/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.calc.rank.ISrcRankResult;
import kd.scm.src.common.util.SrcWinruleUtils;

public class SrcRankHandleOrderRatio
implements ISrcRankResult {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        if ("1".equals(context.getRatioType())) {
            return;
        }
        boolean isUpdateResult = ExtFilterUtils.isMatchSourceTypeAndSourceFlow((Object)SrcCalcHelper.convertContext(context), (String)this.getClass().getName(), (String)ISrcRankResult.class.getSimpleName());
        if (!isUpdateResult) {
            return;
        }
        List<DynamicObject> rows = context.getPurlistList();
        if (Objects.isNull(rows)) {
            return;
        }
        Map<Long, List<DynamicObject>> purlistMap = rows.stream().filter(e -> context.getRatioResultSet().contains(e.getString("result"))).sorted(Comparator.comparing(row -> ((DynamicObject)row).getLong("purlist.id")).thenComparing(row -> ((DynamicObject)row).getString("result"))).collect(Collectors.groupingBy(e -> e.getLong("purlist.id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : purlistMap.entrySet()) {
            if ("9".equals(context.getRatioType())) {
                this.allocateRatioHundred(context, entry.getValue());
                continue;
            }
            BigDecimal surplusRatio = this.allocateRatio(context, entry.getValue());
            this.allocateSurplusRatio(context, entry.getValue(), surplusRatio);
        }
    }

    private BigDecimal allocateRatio(SrcCalcContext context, List<DynamicObject> rows) {
        BigDecimal surplusRatio = BigDecimal.TEN.multiply(BigDecimal.TEN);
        long keyId = SrmCommonUtil.getPkValue((DynamicObject)rows.get(0).getDynamicObject(context.getRatioKeyField()));
        for (DynamicObject row : rows) {
            int rank = row.getInt("rank");
            String key = String.valueOf(keyId) + '|' + SrcWinruleUtils.formatInt(rank, false);
            BigDecimal orderRatio = context.getOrderRatioMap().get(key);
            if (null == orderRatio) continue;
            row.set("orderratio", (Object)orderRatio);
            surplusRatio = surplusRatio.subtract(orderRatio);
        }
        return surplusRatio;
    }

    private void allocateRatioHundred(SrcCalcContext context, List<DynamicObject> rows) {
        BigDecimal hundred = BigDecimal.TEN.multiply(BigDecimal.TEN);
        for (DynamicObject row : rows) {
            BigDecimal orderRatio = row.getBigDecimal("orderratio");
            if (orderRatio.compareTo(BigDecimal.ZERO) != 0) continue;
            row.set("orderratio", (Object)hundred);
        }
    }

    private void allocateSurplusRatio(SrcCalcContext context, List<DynamicObject> rows, BigDecimal surplusRatio) {
        long keyId = SrmCommonUtil.getPkValue((DynamicObject)rows.get(0).getDynamicObject(context.getRatioKeyField()));
        String surplusType = PdsCommonUtils.object2String((Object)context.getSurplusRatioMap().get(keyId), (String)"1");
        if (surplusRatio.compareTo(BigDecimal.ZERO) == 0 || Objects.equals(surplusType, "9")) {
            return;
        }
        switch (surplusType) {
            case "1": {
                this.allocateSurplusRatioByFirst(context, rows, surplusRatio);
                break;
            }
            case "2": {
                this.allocateSurplusRatioByWeight(context, rows, surplusRatio);
                break;
            }
            case "3": {
                this.allocateSurplusRatioByAverage(context, rows, surplusRatio);
                break;
            }
            default: {
                this.allocateSurplusRatioByFirst(context, rows, surplusRatio);
            }
        }
    }

    private void allocateSurplusRatioByFirst(SrcCalcContext context, List<DynamicObject> rows, BigDecimal surplusRatio) {
        BigDecimal firstOrderratio = rows.get(0).getBigDecimal("orderratio").add(surplusRatio);
        rows.get(0).set("orderratio", (Object)firstOrderratio);
    }

    private void allocateSurplusRatioByWeight(SrcCalcContext context, List<DynamicObject> rows, BigDecimal surplusRatio) {
        BigDecimal totalOrderRatio = BigDecimal.TEN.multiply(BigDecimal.TEN).subtract(surplusRatio);
        BigDecimal allocatableSurplusRatio = surplusRatio;
        int index = 0;
        for (DynamicObject row : rows) {
            BigDecimal currentOrderRatio = row.getBigDecimal("orderratio");
            BigDecimal weightSurplusRatio = allocatableSurplusRatio.multiply(currentOrderRatio).divide(totalOrderRatio).setScale(2, 4);
            BigDecimal weightOrderRatio = currentOrderRatio.add(weightSurplusRatio);
            row.set("orderratio", (Object)weightOrderRatio);
            surplusRatio = surplusRatio.subtract(weightSurplusRatio);
            if (index == rows.size() - 1 && surplusRatio.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal lastOrderRatio = row.getBigDecimal("orderratio").add(surplusRatio);
                row.set("orderratio", (Object)lastOrderRatio);
            }
            ++index;
        }
    }

    private void allocateSurplusRatioByAverage(SrcCalcContext context, List<DynamicObject> rows, BigDecimal surplusRatio) {
        BigDecimal avgSurplusRatio = surplusRatio.divide(new BigDecimal(rows.size())).setScale(2, 4);
        int index = 0;
        for (DynamicObject row : rows) {
            BigDecimal currentOrderRatio = row.getBigDecimal("orderratio");
            BigDecimal avgOrderratio = currentOrderRatio.add(avgSurplusRatio);
            row.set("orderratio", (Object)avgOrderratio);
            surplusRatio = surplusRatio.subtract(avgSurplusRatio);
            if (index == rows.size() - 1 && surplusRatio.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal lastOrderRatio = row.getBigDecimal("orderratio").add(surplusRatio);
                row.set("orderratio", (Object)lastOrderRatio);
            }
            ++index;
        }
    }
}

