/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.calc.rank.ISrcRankResult;

public class SrcRankHandlePkgAmt
implements ISrcRankResult {
    @Override
    public void process(SrcCalcContext context) {
        if (QueryServiceHelper.exists((String)"src_pkgamount_meta", (QFilter[])new QFilter("billid", "=", (Object)context.getBillId()).toArray())) {
            return;
        }
        HashMap<String, Map<String, BigDecimal>> pkgMap = new HashMap<String, Map<String, BigDecimal>>(16);
        this.getPackageAmount(context, pkgMap);
        this.createPackageAmountEntry(context, pkgMap);
    }

    protected void getPackageAmount(SrcCalcContext context, Map<String, Map<String, BigDecimal>> pkgMap) {
        QFilter qFilter = new QFilter("project.id", "=", (Object)context.getBillId()).and("isdiscarded", "=", (Object)"0").and("entrystatus", "=", (Object)"C");
        DynamicObject[] purlistObjs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)"project,suppliertype,supplier,suppliername,package,purlist,billid,qty,price,amount,taxrate,tax,taxprice,taxamount,locamount,loctaxamount,discount,feerate,rebate,percent,decrease,transcost,bizamount,vieamount,ratio,weight,calcvalue,price_uom", (QFilter[])new QFilter[]{qFilter}, (String)"supplier,package,purlist");
        if (purlistObjs == null || purlistObjs.length == 0) {
            return;
        }
        for (DynamicObject purlistObj : purlistObjs) {
            Map<Object, Object> amountMap;
            String key1 = String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)purlistObj.getDynamicObject("supplier")));
            String key2 = String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)purlistObj.getDynamicObject("package")));
            String key = key1 + "|" + key2 + "|0";
            BigDecimal locamount = purlistObj.getBigDecimal("locamount");
            BigDecimal loctaxamount = purlistObj.getBigDecimal("loctaxamount");
            if (pkgMap.get(key) == null) {
                amountMap = new HashMap(16);
                amountMap.put("amount", locamount);
                amountMap.put("taxamount", loctaxamount);
                pkgMap.put(key, amountMap);
                continue;
            }
            amountMap = pkgMap.get(key);
            amountMap.put("amount", locamount.add((BigDecimal)amountMap.get("amount")));
            amountMap.put("taxamount", loctaxamount.add((BigDecimal)amountMap.get("taxamount")));
            pkgMap.put(key, amountMap);
        }
    }

    protected void createPackageAmountEntry(SrcCalcContext context, Map<String, Map<String, BigDecimal>> pkgMap) {
        ArrayList<DynamicObject> pkgAmountList = new ArrayList<DynamicObject>(16);
        int index = 1;
        for (Map.Entry<String, Map<String, BigDecimal>> entry : pkgMap.entrySet()) {
            Map<String, Object> idMap = SrcCalcHelper.getRankObjectIdFromKey(context.getSumType(), entry.getKey());
            long supplierId = PdsCommonUtils.object2Long((Object)idMap.get("supplierid"));
            long packageId = PdsCommonUtils.object2Long((Object)idMap.get("packageid"));
            DynamicObject entryObj = BusinessDataServiceHelper.newDynamicObject((String)"src_pkgamount_meta");
            entryObj.set("billid", (Object)context.getBillId());
            entryObj.set("fseq", (Object)index++);
            entryObj.set("supplier_id", (Object)supplierId);
            entryObj.set("suppliertype", (Object)context.getSupTypeMap().get(String.valueOf(supplierId)));
            entryObj.set("package_id", (Object)packageId);
            entryObj.set("pkgamount", (Object)entry.getValue().get("amount"));
            entryObj.set("pkgtaxamount", (Object)entry.getValue().get("taxamount"));
            entryObj.set("turns", (Object)QuoteTurnsEnums.NEGOTIATE00.getValue());
            entryObj.set("entrystatus", (Object)"C");
            entryObj.set("entryparentid", (Object)context.getBillId());
            pkgAmountList.add(entryObj);
        }
        context.setPkgAmountObjs(pkgAmountList.toArray(new DynamicObject[0]));
    }
}

