/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsDefaultConfigUtil;
import kd.scm.pds.common.util.SrcDateUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.rank.ISrcRankResult;

public class SrcRankHandlePurOrderPrice
implements ISrcRankResult {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        Object isProcessed = context.getGlobalContext().getCustomMap().get(SrcRankHandlePurOrderPrice.class.getSimpleName());
        if (null != isProcessed && isProcessed.toString().equals("1")) {
            return;
        }
        DynamicObject[] rows = this.getUpdatePurlistRows(context);
        if (rows.length == 0) {
            return;
        }
        Set<Long> materialIds = Arrays.asList(rows).stream().map(e -> e.getLong("material.id")).collect(Collectors.toSet());
        Set<Long> unitIds = Arrays.asList(rows).stream().map(e -> e.getLong("unit.id")).collect(Collectors.toSet());
        Set<Long> currencyIds = Arrays.asList(rows).stream().map(e -> e.getLong("currency.id")).collect(Collectors.toSet());
        Map<String, List<DynamicObject>> purlistMap = Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getString("material.id") + '_' + e.getString("unit.id") + '_' + e.getString("currency.id")));
        ArrayList<DynamicObject> purlistList = new ArrayList<DynamicObject>();
        QFilter qfilters = this.getPurOrderFilter(context, materialIds, unitIds, currencyIds);
        Map<String, DynamicObject> purOrderMap = this.getPurOrderRows(context, qfilters);
        if (purOrderMap.size() > 0) {
            this.setPurOrderPrice(context, purlistMap, purlistList, purOrderMap, "price2", "price3");
        }
        PdsCommonUtils.saveDynamicObjects(purlistList);
        context.getGlobalContext().getCustomMap().put(SrcRankHandlePurOrderPrice.class.getSimpleName(), "1");
    }

    private void setPurOrderPrice(SrcCalcContext context, Map<String, List<DynamicObject>> purlistMap, List<DynamicObject> purlistList, Map<String, DynamicObject> purOrderMap, String price, String taxprice) {
        for (Map.Entry<String, List<DynamicObject>> entry : purlistMap.entrySet()) {
            DynamicObject purOrderObj = purOrderMap.get(entry.getKey());
            if (null == purOrderObj) continue;
            for (DynamicObject row : entry.getValue()) {
                row.set(price, (Object)purOrderObj.getBigDecimal("materialentry.price"));
                row.set(taxprice, (Object)purOrderObj.getBigDecimal("materialentry.taxprice"));
            }
            purlistList.addAll((Collection<DynamicObject>)entry.getValue());
        }
    }

    private Map<String, DynamicObject> getPurOrderRows(SrcCalcContext context, QFilter qfilters) {
        String selectFields = "billdate,curr.id,materialentry.material.id,materialentry.unit.id,materialentry.price,materialentry.taxprice";
        String orderby = " materialentry.material, materialentry.unit,curr.id, billdate desc, auditdate desc";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"pur_order", (String)selectFields, (QFilter[])qfilters.toArray(), (String)orderby);
        return rows.stream().collect(Collectors.groupingBy(e -> e.getString("materialentry.material.id") + '_' + e.getString("materialentry.unit.id") + '_' + e.getString("curr.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
    }

    private QFilter getPurOrderFilter(SrcCalcContext context, Set<Long> materialIds, Set<Long> unitIds, Set<Long> currencyIds) {
        QFilter projectFilter = new QFilter("id", "=", context.getProjectObj().getPkValue());
        DynamicObject baseObj = QueryServiceHelper.queryOne((String)"src_project_base", (String)"monthnum", (QFilter[])projectFilter.toArray());
        int monthnum = baseObj.getInt("monthnum");
        if (monthnum == 0) {
            monthnum = Integer.parseInt(PdsDefaultConfigUtil.getDefaultValue((DynamicObject)baseObj, (String)"src_project", (String)"src_project_base", (String)"monthnum", (Object)12).toString());
        }
        Date historyDate = SrcDateUtils.getDateByOffsetDay((Date)TimeServiceHelper.now(), (int)(-monthnum * 30));
        QFilter qfilters = new QFilter("billstatus", "in", (Object)PdsCommonUtils.buildSet((String[])new String[]{BillStatusEnum.AUDIT.getVal(), BillStatusEnum.CLOSED.getVal()}));
        qfilters.and("billdate", ">=", (Object)historyDate);
        qfilters.and("materialentry.material", "in", materialIds);
        qfilters.and("materialentry.unit", "in", unitIds);
        qfilters.and("curr", "in", currencyIds);
        qfilters.and(new QFilter("materialentry.price", ">", (Object)BigDecimal.ZERO).or("materialentry.taxprice", ">", (Object)BigDecimal.ZERO));
        return qfilters;
    }

    private DynamicObject[] getUpdatePurlistRows(SrcCalcContext context) {
        String selectFields = "material,unit,currency,price2,price3";
        QFilter qfilters = this.getProjectPurlistFilter(context);
        return BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])qfilters.toArray());
    }

    private QFilter getProjectPurlistFilter(SrcCalcContext context) {
        QFilter qfilters = new QFilter("project", "=", context.getProjectObj().getPkValue());
        qfilters.and("entrystatus", "in", (Object)PdsCommonUtils.buildSet((String[])new String[]{ProjectStatusEnums.OPENED.getValue(), ProjectStatusEnums.CLOSED.getValue()}));
        qfilters.and("material", ">", (Object)0L);
        return qfilters;
    }
}

