/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcDateUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.rank.ISrcRankSorter;

public class SrcRankSortByValueAndTime
implements ISrcRankSorter {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        DynamicObject[] array = this.sortByValueAndTime(context);
        context.setAssessArray(array);
    }

    protected DynamicObject[] sortByValueAndTime(SrcCalcContext context) {
        DynamicObject[] arrays = context.getAssessArray();
        if (arrays.length == 0) {
            return arrays;
        }
        Date deliverDate = SrcDateUtils.getMaxDate();
        Date quoteDate = TimeServiceHelper.now();
        Map<String, Date> supQuoteTimeMap = this.getSupValidTime(context);
        this.shellSort(context, arrays, deliverDate, quoteDate, supQuoteTimeMap);
        return arrays;
    }

    public void shellSort(SrcCalcContext context, DynamicObject[] arrays, Date deliverDate, Date quoteDate, Map<String, Date> supQuoteTimeMap) {
        DynamicObject temp = null;
        int index = 0;
        for (int gap = arrays.length / 2; gap > 0; gap /= 2) {
            for (int i = gap; i < arrays.length; ++i) {
                temp = arrays[i];
                for (index = i - gap; index >= 0 && this.isLargeThen(temp, arrays[index], context, arrays, deliverDate, quoteDate, supQuoteTimeMap); index -= gap) {
                    arrays[index + gap] = arrays[index];
                }
                if (index + gap == i) continue;
                arrays[index + gap] = temp;
            }
        }
    }

    public boolean isLargeThen(DynamicObject obj1, DynamicObject obj2, SrcCalcContext context, DynamicObject[] arrays, Date deliverDate, Date quoteDate, Map<String, Date> supQuoteTimeMap) {
        String resultranktype;
        String key1 = this.getKey(context, obj1);
        BigDecimal sumscore1 = obj1.getBigDecimal("sumscore");
        BigDecimal bizamount1 = obj1.getBigDecimal("bizamount");
        Date deliverDate1 = this.getDate(supQuoteTimeMap, key1, "deliverdate", deliverDate);
        Date quoteDate1 = this.getDate(supQuoteTimeMap, key1, "quotedate", quoteDate);
        BigDecimal bizScore1 = obj1.getBigDecimal("bizscore");
        BigDecimal tecScore1 = obj1.getBigDecimal("tecscore").add(obj1.getBigDecimal("othscore"));
        String key2 = this.getKey(context, obj2);
        BigDecimal sumscore2 = obj2.getBigDecimal("sumscore");
        BigDecimal bizamount2 = obj2.getBigDecimal("bizamount");
        Date deliverDate2 = this.getDate(supQuoteTimeMap, key2, "deliverdate", deliverDate);
        Date quoteDate2 = this.getDate(supQuoteTimeMap, key2, "quotedate", quoteDate);
        BigDecimal bizScore2 = obj2.getBigDecimal("bizscore");
        BigDecimal tecScore2 = obj2.getBigDecimal("tecscore").add(obj2.getBigDecimal("othscore"));
        switch (resultranktype = PdsCommonUtils.object2String((Object)context.getSchemeObj().get("resultranktype"), (String)"1")) {
            case "1": {
                if (sumscore1.compareTo(sumscore2) > 0) {
                    return true;
                }
                if (sumscore1.compareTo(sumscore2) >= 0) break;
                return false;
            }
            case "2": {
                if (bizScore1.compareTo(bizScore2) > 0) {
                    return true;
                }
                if (bizScore1.compareTo(bizScore2) < 0) {
                    return false;
                }
                if (tecScore1.compareTo(tecScore2) > 0) {
                    return true;
                }
                if (tecScore1.compareTo(tecScore2) >= 0) break;
                return false;
            }
            case "3": {
                if (tecScore1.compareTo(tecScore2) > 0) {
                    return true;
                }
                if (tecScore1.compareTo(tecScore2) < 0) {
                    return false;
                }
                if (bizScore1.compareTo(bizScore2) > 0) {
                    return true;
                }
                if (bizScore1.compareTo(bizScore2) >= 0) break;
                return false;
            }
        }
        if (bizamount1.compareTo(bizamount2) != 0) {
            if ("2".equals(context.getRankCalcType()) ? bizamount1.compareTo(bizamount2) > 0 : bizamount1.compareTo(bizamount2) < 0) {
                return true;
            }
        } else {
            if (bizamount1.compareTo(bizamount2) == 0 && deliverDate1.before(deliverDate2)) {
                return true;
            }
            if (bizamount1.compareTo(bizamount2) == 0 && deliverDate1.equals(deliverDate2) && quoteDate1.before(quoteDate2)) {
                return true;
            }
        }
        return false;
    }

    protected Map<String, Date> getSupValidTime(SrcCalcContext context) {
        Date quoteDate = TimeServiceHelper.now();
        Date deliverDate = SrcDateUtils.getMaxDate();
        DynamicObject[] rows = context.getPurlistObjs();
        Map<String, List<DynamicObject>> groupMap = null;
        groupMap = "3".equals(context.getSumType()) ? Arrays.asList(rows).stream().filter(e -> e.getLong("supplier.id") > 0L).collect(Collectors.groupingBy(row -> row.getString("supplier.id") + "_" + row.getString("purlist.id"))) : Arrays.asList(rows).stream().filter(e -> e.getLong("supplier.id") > 0L).collect(Collectors.groupingBy(row -> row.getString("supplier.id")));
        if (groupMap == null || groupMap.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Date> resultMap = new HashMap<String, Date>(groupMap.size());
        for (Map.Entry<String, List<DynamicObject>> groupMapEntry : groupMap.entrySet()) {
            String key = groupMapEntry.getKey();
            List<DynamicObject> list = groupMapEntry.getValue();
            Optional<DynamicObject> deliverDateObj = list.stream().filter(row -> Objects.nonNull(row.getDate("deliverdate"))).min(Comparator.comparing(row -> row.getDate("deliverdate")));
            if (deliverDateObj.isPresent()) {
                resultMap.put(key + '_' + "deliverdate", deliverDateObj.get().getDate("deliverdate"));
            } else {
                resultMap.put(key + '_' + "deliverdate", deliverDate);
            }
            Optional<DynamicObject> quoteDateObj = list.stream().filter(row -> Objects.nonNull(row.getDate("quotedate"))).min(Comparator.comparing(row -> row.getDate("quotedate")));
            if (quoteDateObj.isPresent()) {
                resultMap.put(key + '_' + "quotedate", quoteDateObj.get().getDate("quotedate"));
                continue;
            }
            resultMap.put(key + '_' + "quotedate", quoteDate);
        }
        return resultMap;
    }

    private String getKey(SrcCalcContext context, DynamicObject assessObj) {
        String key = assessObj.getString("supplier_id");
        if ("3".equals(context.getSumType())) {
            long purlist_id = assessObj.getLong("purlist_id");
            purlist_id = context.getEntryid_PurlistidMap().get(purlist_id);
            key = key + '_' + String.valueOf(purlist_id);
        }
        return key;
    }

    private Date getDate(Map<String, Date> dateMap, String key, String field, Date defaultDate) {
        Date dateObj = dateMap.get(key + '_' + field);
        if (null == dateObj) {
            return defaultDate;
        }
        return dateObj;
    }
}

