/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.enums.ResultStatusEnums;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.calc.rank.ISrcRankResult;
import kd.scm.src.common.util.SrcPurListUtil;

public class SrcRankUpdatePurlist
implements ISrcRankResult {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        if (context.isResetPurlist() && null != context.getPurlistObjs()) {
            boolean isUpdateResult = ExtFilterUtils.isMatchSourceTypeAndSourceFlow((Object)SrcCalcHelper.convertContext(context), (String)this.getClass().getName(), (String)ISrcRankResult.class.getSimpleName());
            this.updatePurlistResult(context, isUpdateResult);
        }
    }

    protected void updatePurlistResult(SrcCalcContext context, boolean isUpdateResult) {
        List<DynamicObject> objs = context.getAllAssessList();
        if (CollectionUtils.isEmpty(objs)) {
            return;
        }
        ArrayList<DynamicObject> purlistList = new ArrayList<DynamicObject>(16);
        for (DynamicObject obj : objs) {
            long projectId = obj.getLong("billid");
            long supplierId = obj.getLong("supplier_id");
            long packageId = obj.getLong("package_id");
            long purlistId = obj.getLong("purlist_id");
            int rank = obj.getInt("rank");
            String result = obj.getString("result");
            BigDecimal bizAmount = obj.getBigDecimal("bizamount");
            this.updatePurlistEntry(context, projectId, supplierId, packageId, purlistId, rank, result, bizAmount, purlistList, isUpdateResult);
        }
        if (isUpdateResult) {
            DynamicObjectCollection rows = new DynamicObjectCollection();
            rows.addAll(purlistList);
            SrcPurListUtil.validatorMaterialNaneSupplier(rows);
        }
        context.setPurlistList(purlistList);
    }

    protected void updatePurlistEntry(SrcCalcContext context, long projectId, long supplierId, long packageId, long purlistId, int rank, String result, BigDecimal bizAmount, List<DynamicObject> purlistList, boolean isUpdateResult) {
        List rows = Arrays.asList(context.getPurlistObjs()).stream().filter(e -> this.predicate((DynamicObject)e, projectId, supplierId, packageId, purlistId)).collect(Collectors.toList());
        if (rows == null || rows.size() == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            this.updatePurlistEntryValue(context, rank, result, bizAmount, row, isUpdateResult);
        }
        purlistList.addAll(rows);
    }

    protected boolean predicate(DynamicObject e, long projectId, long supplierId, long packageId, long purlistId) {
        boolean isMatched;
        boolean bl = isMatched = e.getLong("project.id") == projectId && e.getLong("supplier.id") == supplierId;
        if (packageId > 0L) {
            boolean bl2 = isMatched = isMatched && e.getLong("package.id") == packageId;
        }
        if (purlistId > 0L) {
            isMatched = isMatched && e.getLong("id") == purlistId;
        }
        return isMatched;
    }

    protected void updatePurlistEntryValue(SrcCalcContext context, int rank, String result, BigDecimal bizAmount, DynamicObject row, boolean isUpdateResult) {
        String purlistKey;
        String packageKey;
        if (QuoteTurnsEnums.NEGOTIATE00.getValue().equals(row.getString("turns"))) {
            row.set("firstrank", (Object)rank);
        }
        if (SourceTypeEnums.CONFIRM_PRICE.getValue().equals(context.getSourcetype()) && !row.getBoolean("award")) {
            row.set("rank", null);
            row.set("sysresult", (Object)ResultStatusEnums.NOTRECOMMEND.getValue());
            row.set("bizamount", (Object)bizAmount);
            if (StringUtils.isBlank((CharSequence)row.getString("result"))) {
                row.set("result", (Object)ResultStatusEnums.NOTRECOMMEND.getValue());
            }
        } else if (null != result || !row.getBoolean("ispresent")) {
            row.set("rank", (Object)rank);
            row.set("sysresult", (Object)result);
            row.set("bizamount", (Object)bizAmount);
            if (isUpdateResult) {
                row.set("result", (Object)result);
            }
        }
        if (!context.getRatioResultSet().contains(row.getString("result"))) {
            row.set("orderratio", (Object)0);
            row.set("cfmqty", (Object)0);
            row.set("cfmbaseqty", (Object)0);
            row.set("price4", (Object)0);
            row.set("price5", (Object)0);
            row.set("price6", (Object)0);
            row.set("price7", (Object)0);
        }
        if ((packageKey = row.getString("package.id")) != null && context.getRatioMap().get(packageKey) != null && context.getRatioMap().get(packageKey).compareTo(BigDecimal.ZERO) > 0) {
            row.set("ratio", (Object)context.getRatioMap().get(packageKey));
            row.set("weight", (Object)context.getWeightMap().get(packageKey));
        }
        if ((purlistKey = row.getString("purlist.id")) != null && context.getWeightMap().get(purlistKey) != null && context.getWeightMap().get(purlistKey).compareTo(BigDecimal.ZERO) > 0) {
            row.set("ratio", (Object)context.getRatioMap().get(purlistKey));
            row.set("weight", (Object)context.getWeightMap().get(purlistKey));
        }
    }
}

