/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.rank.ISrcRankCoreCalc;

public class SrcRanlCalcAverageValue
implements ISrcRankCoreCalc {
    private static final long serialVersionUID = 1L;

    public BigDecimal calcAverageValue(SrcCalcContext context, List<BigDecimal> bizScoreList, BigDecimal sumValue) {
        int minValueNum;
        int count = bizScoreList.size();
        if (count == 0) {
            return BigDecimal.ZERO;
        }
        int supplierNum = context.getSchemeObj().getInt("suppliernum");
        int supplierNum2 = context.getSchemeObj().getInt("suppliernum2");
        if (supplierNum < 2 || count <= supplierNum) {
            return sumValue.divide(BigDecimal.valueOf(count), 6);
        }
        if (supplierNum2 == 0) {
            supplierNum2 = supplierNum - 1;
        }
        int maxValueNum = minValueNum = count / supplierNum2;
        List sortList = bizScoreList.stream().sorted().collect(Collectors.toList());
        sumValue = BigDecimal.ZERO;
        count = 0;
        for (int i = 0; i < sortList.size(); ++i) {
            if (i < minValueNum || i >= sortList.size() - maxValueNum) continue;
            sumValue = sumValue.add((BigDecimal)sortList.get(i));
            ++count;
        }
        if (count > 0) {
            return sumValue.divide(BigDecimal.valueOf(count), 6);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public void process(SrcCalcContext context) {
    }
}

