/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.ratio;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.ratio.ISrcRatioResult;

public class SrcRatioDelOldData
implements ISrcRatioResult {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        this.deleteInvalidData(context);
        this.clearInvalidData(context);
    }

    protected void deleteInvalidData(SrcCalcContext context) {
        QFilter qfilter = this.getQFilter(context);
        if (!context.getEntityName().equals("src_predecision")) {
            qfilter.and("preamount", "=", (Object)0L);
            qfilter.and("pretaxamount", "=", (Object)0L);
        }
        DeleteServiceHelper.delete((String)"src_decisionsumsup", (QFilter[])qfilter.toArray());
    }

    protected void clearInvalidData(SrcCalcContext context) {
        if (context.getEntityName().equals("src_predecision")) {
            return;
        }
        QFilter qfilter = this.getQFilter(context);
        qfilter.and(new QFilter("preamount", ">", (Object)0L).or("pretaxamount", ">", (Object)0L));
        String selectFields = "amount,orderratio,taxamount,orderratio1";
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_decisionsumsup", (String)selectFields, (QFilter[])qfilter.toArray());
        if (rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            row.set("amount", null);
            row.set("orderratio", null);
            row.set("taxamount", null);
            row.set("orderratio1", null);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    private QFilter getQFilter(SrcCalcContext context) {
        QFilter qfilter = new QFilter("billid", "=", (Object)context.getCompBillId());
        if (context.getWinSupplierObjs() != null && context.getWinSupplierObjs().length > 0) {
            Set idSet = Arrays.asList(context.getWinSupplierObjs()).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            qfilter.and("id", "not in", idSet);
        }
        return qfilter;
    }
}

