/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.ratio;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.ratio.ISrcRatioInit;

public class SrcRatioInitCalcWay
implements ISrcRatioInit {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        ArrayList<Long> billIds = new ArrayList<Long>();
        billIds.add(context.getBillId());
        long currencyId = 0L;
        BigDecimal sumAmount = BigDecimal.ZERO;
        DynamicObjectCollection projectObjs = QueryServiceHelper.query((String)"src_project_base", (String)"currency.id,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        if (projectObjs != null && projectObjs.size() > 0) {
            currencyId = ((DynamicObject)projectObjs.get(0)).getLong("currency.id");
            sumAmount = projectObjs.stream().map(e -> e.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        this.createDecisionsumObj(context, currencyId, sumAmount);
        this.setRatioCalcWay(context);
    }

    protected void createDecisionsumObj(SrcCalcContext context, long currencyId, BigDecimal sumAmount) {
        QFilter qFilter = new QFilter("id", "=", (Object)context.getBillId()).or("parentid", "=", (Object)String.valueOf(context.getBillId()));
        DynamicObject compObj = BusinessDataServiceHelper.loadSingle((String)"src_decisionsum_sup", (String)"id,currency,budgetamount", (QFilter[])qFilter.toArray());
        if (compObj == null) {
            compObj = BusinessDataServiceHelper.newDynamicObject((String)"src_decisionsum_sup");
            compObj.set("parentid", (Object)context.getBillId());
            compObj.set("entitykey", (Object)"src_decisionsum_sup");
            compObj.set("sumtype", (Object)"1");
            compObj.set("isprice", (Object)Boolean.TRUE);
        }
        compObj.set("currency", (Object)currencyId);
        compObj.set("budgetamount", (Object)sumAmount);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{compObj});
    }

    protected void setRatioCalcWay(SrcCalcContext context) {
        String selectFields = "id,sumtype,isproject,ispackage,iscategory,isprice,isallsupplier";
        QFilter qfilter = new QFilter("id", "=", (Object)context.getBillId()).or("parentid", "=", (Object)String.valueOf(context.getBillId()));
        DynamicObject configObj = QueryServiceHelper.queryOne((String)"src_decisionsum_sup", (String)selectFields, (QFilter[])qfilter.toArray());
        if (configObj == null) {
            return;
        }
        String calcWay = configObj.getString("sumtype");
        if (calcWay == null || "".equals(calcWay.trim())) {
            calcWay = "1";
        }
        context.setRatioCalcWay(calcWay);
        context.setAllSupplier(configObj.getBoolean("isallsupplier"));
        context.setIsproject(configObj.getBoolean("isproject"));
        context.setIspackage(configObj.getBoolean("ispackage"));
        context.setIscategory(configObj.getBoolean("iscategory"));
        context.setIsprice(configObj.getBoolean("isprice"));
        context.setCompBillId(configObj.getLong("id"));
    }
}

