/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.total;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.calc.total.ISrcTotalProcess;

public class SrcTotalCalcCfmQty
implements ISrcTotalProcess {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        if (context.getPurlistObjs() == null) {
            return;
        }
        Object isProcessed = context.getGlobalContext().getCustomMap().get(SrcTotalCalcCfmQty.class.getSimpleName());
        if (null != isProcessed && isProcessed.toString().equals("1")) {
            return;
        }
        this.calcCfmQtyAndAmount(context);
        context.getGlobalContext().getCustomMap().put(SrcTotalCalcCfmQty.class.getSimpleName(), "1");
    }

    public void calcCfmQtyAndAmount(SrcCalcContext context) {
        if (null == context.getRatioType()) {
            DynamicObject ratioRuleObj = BusinessDataServiceHelper.loadSingle((Object)context.getBillId(), (String)"src_project_rule");
            context.setRatioType(PdsCommonUtils.object2String((Object)ratioRuleObj.get("ratiotype"), (String)"1"));
        }
        Map<String, List<DynamicObject>> purlistMap = Arrays.asList(context.getPurlistObjs()).stream().collect(Collectors.groupingBy(e -> e.getString("purlist.id")));
        for (Map.Entry<String, List<DynamicObject>> entry : purlistMap.entrySet()) {
            List<DynamicObject> purlistObjs = entry.getValue();
            BigDecimal qty = purlistObjs.get(0).getBigDecimal("qty");
            DynamicObject unit = purlistObjs.get(0).getDynamicObject("unit");
            int scale = null != unit ? unit.getInt("precision") : 8;
            BigDecimal sumCfmQty = BigDecimal.ZERO;
            BigDecimal sumRatio = BigDecimal.ZERO;
            for (DynamicObject purlistObj : purlistObjs) {
                if (context.getRatioType().equals("9") && purlistObj.getBigDecimal("cfmqty").compareTo(BigDecimal.ZERO) > 0) continue;
                BigDecimal ratio = purlistObj.getBigDecimal("orderratio");
                BigDecimal cfmQty = purlistObj.getBigDecimal("qty").multiply(ratio).divide(BigDecimal.TEN).divide(BigDecimal.TEN).setScale(scale, 4);
                purlistObj.set("cfmqty", (Object)cfmQty);
                sumCfmQty = sumCfmQty.add(cfmQty);
                sumRatio = sumRatio.add(ratio);
            }
            BigDecimal diffQty = qty.subtract(sumCfmQty);
            if (sumRatio.compareTo(BigDecimal.TEN.multiply(BigDecimal.TEN)) == 0 && diffQty.compareTo(BigDecimal.ZERO) != 0) {
                DynamicObject purlistObj;
                purlistObj = purlistObjs.get(purlistObjs.size() - 1);
                BigDecimal cfmQty = purlistObj.getBigDecimal("cfmqty").add(diffQty).setScale(scale, 4);
                purlistObj.set("cfmqty", (Object)cfmQty);
            }
            if (context.getRatioType().equals("9")) {
                this.calcDecisionAmountByCfmQty(purlistObjs);
                continue;
            }
            this.calcDecisionAmountByRatio(purlistObjs);
        }
    }

    private void calcDecisionAmountByRatio(List<DynamicObject> purlistObjs) {
        for (DynamicObject purlistObj : purlistObjs) {
            int precision = SrcCalcHelper.getPrecision(purlistObj, "currency");
            int locPrecision = SrcCalcHelper.getPrecision(purlistObj, "loccurr");
            BigDecimal orderRatio = SrcCalcHelper.getOrderRatio(purlistObj);
            purlistObj.set("price4", (Object)orderRatio.multiply(purlistObj.getBigDecimal("amount")).setScale(precision, RoundingMode.HALF_UP));
            purlistObj.set("price5", (Object)orderRatio.multiply(purlistObj.getBigDecimal("taxamount")).setScale(precision, RoundingMode.HALF_UP));
            purlistObj.set("price6", (Object)orderRatio.multiply(purlistObj.getBigDecimal("locamount")).setScale(locPrecision, RoundingMode.HALF_UP));
            purlistObj.set("price7", (Object)orderRatio.multiply(purlistObj.getBigDecimal("loctaxamount")).setScale(locPrecision, RoundingMode.HALF_UP));
        }
    }

    private void calcDecisionAmountByCfmQty(List<DynamicObject> purlistObjs) {
        for (DynamicObject purlistObj : purlistObjs) {
            int precision = SrcCalcHelper.getPrecision(purlistObj, "currency");
            int locPrecision = SrcCalcHelper.getPrecision(purlistObj, "loccurr");
            BigDecimal qtyRatio = SrcCalcHelper.getQtyRatio(purlistObj);
            purlistObj.set("price4", (Object)qtyRatio.multiply(purlistObj.getBigDecimal("amount")).setScale(precision, RoundingMode.HALF_UP));
            purlistObj.set("price5", (Object)qtyRatio.multiply(purlistObj.getBigDecimal("taxamount")).setScale(precision, RoundingMode.HALF_UP));
            purlistObj.set("price6", (Object)qtyRatio.multiply(purlistObj.getBigDecimal("locamount")).setScale(locPrecision, RoundingMode.HALF_UP));
            purlistObj.set("price7", (Object)qtyRatio.multiply(purlistObj.getBigDecimal("loctaxamount")).setScale(locPrecision, RoundingMode.HALF_UP));
        }
    }
}

