/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.scm.pds.common.util.ListSelectUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class ListOpenChangePage
extends AbstractListPlugin {
    private static void openBillPage(IFormView currView, String pageKey, Object billId, BillOperationStatus openStatus, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack) {
        BillShowParameter bsp = new BillShowParameter();
        bsp.setFormId(pageKey);
        bsp.setPkId(billId);
        bsp.setBillStatus(openStatus);
        bsp.getOpenStyle().setShowType(showType);
        if (paramMap != null) {
            bsp.setCustomParams(paramMap);
        }
        if (closeCallBack != null) {
            bsp.setCloseCallBack(closeCallBack);
        }
        currView.showForm((FormShowParameter)bsp);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "bidchange": {
                BillList list = (BillList)this.getView().getControl("billlistap");
                Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
                if (objects.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ListOpenChangePage_0", (String)"scm-src-common", (Object[])new Object[0]));
                    return;
                }
                if (objects.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ListOpenChangePage_1", (String)"scm-src-common", (Object[])new Object[0]));
                    return;
                }
                if (objects.length != 1) break;
                Object bidChangeId = SrcBidChangeUtil.getBidChangeObjId("src_bidchange", "project", objects[0]);
                if (bidChangeId == null) {
                    HashMap<String, Object> params = new HashMap<String, Object>(16);
                    params.put("project", objects[0]);
                    ListOpenChangePage.openBillPage(this.getView(), "src_bidchange", null, BillOperationStatus.EDIT, ShowType.MainNewTabPage, params, null);
                    break;
                }
                args.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u5bfb\u6e90\u9879\u76ee\u5df2\u6709\u672a\u5904\u7406\u7684\u53d8\u66f4\u5355,\u8bf7\u5148\u5904\u7406\u3002", (String)"ListOpenChangePage_2", (String)"scm-src-common", (Object[])new Object[0]));
                return;
            }
            case "changequery": {
                long projectId = ListSelectUtils.selectOne((IFormView)this.getView());
                HashMap<String, Long> paraMap = new HashMap<String, Long>(1);
                paraMap.put("projectid", projectId);
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_changequery", (ShowType)ShowType.Modal, paraMap, null);
                break;
            }
        }
    }
}

