/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.src.common.contract.SrcContractUtils;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class OpenChangePage
extends AbstractBillPlugIn {
    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String key;
        super.beforeDoOperation(evt);
        DynamicObject obj = this.getModel().getDataEntity();
        String entityName = this.getView().getEntityId();
        switch (key = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "bidchange": 
            case "batchdecision": {
                String message = SrcContractUtils.contractHasPush(obj);
                if (null != message) {
                    this.getView().showMessage(message);
                    evt.setCancel(true);
                    return;
                }
                Object pkValue = obj.getPkValue();
                if ("src_negotiatebill".equals(entityName)) {
                    pkValue = obj.getDynamicObject("project").getPkValue();
                }
                String fieldName = "project";
                if (entityName.equals("src_apply")) {
                    fieldName = "apply";
                } else if (entityName.equals("src_demand")) {
                    fieldName = "demand";
                }
                String chgEntityName = "src_bidchange";
                if (key.equals("batchdecision")) {
                    chgEntityName = "src_batchdecision";
                }
                Object bidChangeId = SrcBidChangeUtil.getBidChangeObjId(chgEntityName, fieldName, pkValue);
                HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
                paraMap.put("entityname", entityName);
                paraMap.put("project", pkValue);
                paraMap.put("org", SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("org")));
                if ("src_negotiatebill".equals(entityName)) {
                    paraMap.put("negotiate", obj.getPkValue());
                }
                OpenFormUtils.openBillPage((IFormView)this.getView(), (String)chgEntityName, (Object)bidChangeId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, paraMap, null);
                break;
            }
            case "changequery": {
                HashMap<String, Object> queryParaMap = new HashMap<String, Object>(8);
                queryParaMap.put("entityname", entityName);
                if ("src_negotiatebill".equals(this.getView().getEntityId())) {
                    queryParaMap.put("projectid", obj.getDynamicObject("project").getPkValue());
                } else {
                    queryParaMap.put("projectid", obj.getPkValue());
                }
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_changequery", (ShowType)ShowType.Modal, queryParaMap, null);
                break;
            }
        }
    }
}

