/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.util.CheckPermission4OrgUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcBidChangeQuery
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        if (paraMap == null) {
            return;
        }
        Object projectIdObj = paraMap.get("projectid");
        if (null == projectIdObj) {
            return;
        }
        long projectId = PdsCommonUtils.object2Long(projectIdObj);
        String entityName = (String)paraMap.get("entityname");
        String keyField = "project";
        if ("src_apply".equals(entityName)) {
            keyField = "apply";
        } else if ("src_demand".equals(entityName)) {
            keyField = "demand";
        }
        QFilter filters = new QFilter(keyField, "=", (Object)projectId);
        QFilter templateFilter = new QFilter("template.biznode.number", "!=", (Object)PdsBizNodeEnums.BATCHDECISION.getValue());
        templateFilter.or("template", "=", (Object)0L);
        filters.and(templateFilter);
        Object supplierId = this.getView().getFormShowParameter().getCustomParam("supplierid");
        filters.and("supplier.id", "=", (Object)PdsCommonUtils.object2Long((Object)supplierId));
        String selectFields = "project.billno bidnum,project.bidname bidname,billno,billdate,template.id template,remark,billstatus,id billid";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_bidchange", (String)selectFields, (QFilter[])filters.toArray(), (String)"billdate");
        if (rows == null || rows.size() == 0) {
            return;
        }
        this.getModel().setValue("bidnum", ((DynamicObject)rows.get(0)).get("bidnum"));
        this.getModel().setValue("bidname", ((DynamicObject)rows.get(0)).get("bidname"));
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        for (DynamicObject row : rows) {
            ts.set("seq", (Object)(i + 1), i);
            ts.set("billno", row.get("billno"), i);
            ts.set("billdate", row.get("billdate"), i);
            ts.set("template", row.get("template"), i);
            ts.set("remark", row.get("remark"), i);
            ts.set("billstatus", row.get("billstatus"), i);
            ts.set("billid", row.get("billid"), i);
            ++i;
        }
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        int rowIndex = evt.getRowIndex();
        if ("billno".equals(fieldName)) {
            boolean isPermission;
            String entityName;
            Object billId = this.getModel().getValue("billid", rowIndex);
            if (billId == null || billId.toString().length() == 0) {
                return;
            }
            IFormView parentView = this.getView().getParentView();
            if (Objects.isNull(parentView)) {
                return;
            }
            String entityId = parentView.getEntityId();
            if (entityId.startsWith("src")) {
                entityName = "src_bidchange";
                isPermission = CheckPermission4OrgUtils.checkPermission4Org((String)entityName, (String)billId.toString(), (String)"4715a0df000000ac", (String)"0DUM2+6E41IA");
            } else if (entityId.startsWith("tnd")) {
                entityName = "tnd_bidchange";
                isPermission = CheckPermission4OrgUtils.checkPermission4Org((String)entityName, (String)billId.toString(), (String)"4715a0df000000ac", (String)"0DUMFA=HL9S1");
            } else {
                entityName = "src_bidchange";
                isPermission = CheckPermission4OrgUtils.checkPermission4Org((String)entityName, (String)billId.toString(), (String)"4715a0df000000ac", (String)"0DUM2+6E41IA");
            }
            if (!isPermission) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u201c\u9879\u76ee\u53d8\u66f4\u201d\u7684\u65b0\u589e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SrcBidChangeQuery_0", (String)"scm-src-common", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
            paraMap.put("entityname", entityId);
            paraMap.put("project", billId);
            OpenFormUtils.openBillPage((IFormView)this.getView(), (String)entityName, (Object)Long.valueOf(billId.toString()), (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, paraMap, null);
        }
    }
}

