/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pds.common.change.IDataValidateService;
import kd.scm.pds.common.change.ValidateEvent;
import kd.scm.pds.common.change.ValidateResult;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.bidopen.SrcBidOpenUtils;
import kd.scm.src.common.util.SrcProjectLockUtil;

public class SrcBidDateOpenValidateService
implements IDataValidateService {
    private static final long serialVersionUID = 1L;

    public ValidateResult validate(ValidateEvent validateEvent) {
        ValidateResult result = new ValidateResult();
        result.setSuccess(false);
        DynamicObject bidChangeObj = validateEvent.getObj();
        DynamicObject projectObj = bidChangeObj.getDynamicObject("project");
        if (null == projectObj) {
            return this.getUnSuccedResult(result, ResManager.loadKDString((String)"\u5bfb\u6e90\u9879\u76ee\u4e0d\u5b58\u5728\u3002", (String)"SrcBidDateOpenValidateService_0", (String)"scm-src-common", (Object[])new Object[0]));
        }
        boolean isOpenTecBefore = SrcBidOpenUtils.isOpenTecBeforePublish(projectObj);
        DynamicObject bidOpenObj = TemplateUtil.getCompData((DynamicObject)projectObj, (String)"src_bidopen_open");
        DynamicObjectCollection openObjCol = bidOpenObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject openObj : openObjCol) {
            Boolean isTecOpen = openObj.getBoolean("istecopen");
            if (isTecOpen.booleanValue() && !isOpenTecBefore) {
                return this.getUnSuccedResult(result, ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u5f00\u6280\u672f\u6807\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"SrcBidDateOpenValidateService_3", (String)"scm-src-common", (Object[])new Object[0]));
            }
            Boolean isBizOpen = openObj.getBoolean("isbizopen");
            if (isBizOpen.booleanValue()) {
                return this.getUnSuccedResult(result, ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u5f00\u5546\u52a1\u6807\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"SrcBidDateOpenValidateService_4", (String)"scm-src-common", (Object[])new Object[0]));
            }
            String lockKey = SrcProjectLockUtil.getBidAutoLockKey(projectObj.getLong("id"));
            if (!SrcProjectLockUtil.tryLockProject(lockKey)) {
                SrcProjectLockUtil.unLockProject(lockKey);
                return this.getUnSuccedResult(result, ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u81ea\u52a8\u5f00\u6807\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"SrcBidDateOpenValidateService_2", (String)"scm-src-common", (Object[])new Object[0]));
            }
            SrcProjectLockUtil.unLockProject(lockKey);
        }
        result.setSuccess(true);
        return result;
    }
}

