/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcBidNumResHandleService
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        Map<Long, DynamicObject> entryIdMap = this.getChgEntryIdMap(bidChangeObj);
        DynamicObject[] purlistObjs = this.getPurlistObjs(bidChangeObj, entryIdMap);
        this.updatePurlist(purlistObjs, entryIdMap);
        String message = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"SrcBidNumResHandleService_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    protected Map<Long, DynamicObject> getChgEntryIdMap(DynamicObject bidChangeObj) {
        DynamicObject chgCompObj = TemplateUtil.getCompData((DynamicObject)bidChangeObj, (String)"src_decisionchg");
        DynamicObjectCollection rows = chgCompObj.getDynamicObjectCollection("entryentity");
        return rows.stream().filter(e -> e.getBoolean("isnew")).collect(Collectors.toMap(obj -> Optional.ofNullable(obj.getString("srcentryid")).map(Long::parseLong).orElse(0L), obj -> obj));
    }

    protected DynamicObject[] getPurlistObjs(DynamicObject bidChangeObj, Map<Long, DynamicObject> entryIdMap) {
        long projectId = bidChangeObj.getLong("project.id");
        QFilter qfilter = new QFilter("project", "=", (Object)projectId).and("id", "in", entryIdMap.keySet());
        String seelctFields = DynamicObjectUtil.getSelectfields((String)"src_purlistf7", (boolean)false);
        return BusinessDataServiceHelper.load((String)"src_purlistf7", (String)seelctFields, (QFilter[])qfilter.toArray());
    }

    protected void updatePurlist(DynamicObject[] purlistObjs, Map<Long, DynamicObject> entryIdMap) {
        QFilter qfilter = new QFilter("id", "=", (Object)purlistObjs[0].getLong("project.id"));
        String selectFields = "currency.id curr,currency.amtprecision amtprecision,taxtype,decisiontype";
        DynamicObject projectObj = QueryServiceHelper.queryOne((String)"src_projectf7", (String)selectFields, (QFilter[])qfilter.toArray());
        List properties = null;
        for (DynamicObject purlistObj : purlistObjs) {
            DynamicObject newObj = entryIdMap.get(purlistObj.getLong("id"));
            if (!Objects.nonNull(newObj)) continue;
            if (null == properties) {
                properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)newObj);
            }
            this.setPurlistValue(purlistObj, newObj, properties);
            this.calcPriceAndAmount(projectObj, purlistObj, newObj);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])purlistObjs);
    }

    protected void calcPriceAndAmount(DynamicObject projectObj, DynamicObject purlistObj, DynamicObject newPurlistObj) {
        if ("2".equals(projectObj.getString("decisiontype"))) {
            this.calcPriceAndAmountByAmount(projectObj, purlistObj);
        } else if (purlistObj.getBigDecimal("qty").compareTo(newPurlistObj.getBigDecimal("qty")) != 0) {
            this.calcPriceAndAmountByQty(projectObj, purlistObj);
        } else {
            this.calcPriceAndAmountByPrice(projectObj, purlistObj);
        }
    }

    protected void calcPriceAndAmountByQty(DynamicObject projectObj, DynamicObject purlistObj) {
        Cal4DynamicObj.calEntryByQty((DynamicObject)projectObj, (DynamicObject)purlistObj);
    }

    protected void calcPriceAndAmountByAmount(DynamicObject projectObj, DynamicObject purlistObj) {
        if ("2".equals(projectObj.getString("taxtype"))) {
            Cal4DynamicObj.calEntryByAmount((DynamicObject)projectObj, (DynamicObject)purlistObj);
        } else {
            Cal4DynamicObj.calEntryByTaxAmount((DynamicObject)projectObj, (DynamicObject)purlistObj);
        }
    }

    protected void calcPriceAndAmountByPrice(DynamicObject projectObj, DynamicObject purlistObj) {
        if ("2".equals(projectObj.getString("taxtype"))) {
            Cal4DynamicObj.calEntryByPrice((DynamicObject)projectObj, (DynamicObject)purlistObj);
        } else {
            Cal4DynamicObj.calEntryByTaxPrice((DynamicObject)projectObj, (DynamicObject)purlistObj);
        }
        int price_uom = purlistObj.getInt("price_uom");
        if (price_uom > 0) {
            int amtprecision = projectObj.getInt("amtprecision");
            BigDecimal amount = purlistObj.getBigDecimal("amount").divide(new BigDecimal(price_uom), amtprecision, RoundingMode.HALF_DOWN);
            BigDecimal taxAmount = purlistObj.getBigDecimal("taxamount").divide(new BigDecimal(price_uom), amtprecision, RoundingMode.HALF_DOWN);
            purlistObj.set("amount", (Object)amount);
            purlistObj.set("taxamount", (Object)taxAmount);
        }
    }

    protected void setPurlistValue(DynamicObject purlistObj, DynamicObject newObj, List<String> properties) {
        for (String fieldName : properties) {
            if (fieldName.contains("_new")) {
                purlistObj.set(fieldName.substring(0, fieldName.lastIndexOf(95) <= 0 ? fieldName.length() : fieldName.lastIndexOf(95)), newObj.get(fieldName));
                continue;
            }
            if (!"baseunit".equals(fieldName) && !"baseqty".equals(fieldName)) continue;
            purlistObj.set(fieldName, newObj.get(fieldName));
        }
    }

    public void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

