/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.enums.SrcProjectEnum;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcBidProjectEndHandleNegotiateStatus
implements IDataHandleService {
    private static final long serialVersionUID = 4779904550923800713L;

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        long projectId = bidChangeObj.getDynamicObject("project").getLong("id");
        String bizType = null;
        DynamicObject projectEndObj = BusinessDataServiceHelper.loadSingle((String)"src_projectend", (String)"biztype,currentnode", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)String.valueOf(bidChangeObj.getPkValue()))});
        if (null != projectEndObj) {
            bizType = projectEndObj.getString("biztype");
        }
        if (null == bizType || "".equals(bizType.trim())) {
            bizType = ProcessStatusEnums.CLOSED.getValue();
        }
        this.updateNegotiateStatus(projectId, bizType);
        String message = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"SrcBidProjectEndHandleNegotiateStatus_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    public void updateNegotiateStatus(long projectId, String bizType) {
        QFilter qFilter = new QFilter("project", "=", (Object)projectId);
        if (!QueryServiceHelper.exists((String)"src_negotiatebill", (QFilter[])qFilter.toArray())) {
            return;
        }
        DynamicObject[] billObjs = BusinessDataServiceHelper.load((String)"src_negotiatebill", (String)"billstatus,bizstatus", (QFilter[])qFilter.toArray());
        if (billObjs.length == 0) {
            return;
        }
        for (DynamicObject billObj : billObjs) {
            billObj.set("bizstatus", (Object)bizType);
            billObj.set("billstatus", (Object)SrcProjectEnum.AUDIT.getCode());
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])billObjs);
    }

    private void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

