/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.feemanage.FeeManageUtils;
import kd.scm.src.common.util.SrcBidChangeUtil;
import kd.scm.src.common.util.SrcBidCompTplUtil;
import kd.scm.src.common.util.SrcQuoteUtil;
import kd.scm.src.common.util.SrcTenderUtil;

public class SrcBidReplenishPublishService
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        DynamicObject[] bidChangeObjs = new DynamicObject[]{bidChangeObj};
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)bidChangeObj.getDynamicObject("project"));
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        if (!QueryServiceHelper.exists((String)"tnd_tenderbill", (QFilter[])qfilter.toArray()) && !QueryServiceHelper.exists((String)"tnd_quotebill", (QFilter[])qfilter.toArray())) {
            return result;
        }
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project");
        DynamicObject[] projectObjs = new DynamicObject[]{projectObj};
        DynamicObject[] autoPublishObj = SrcBidCompTplUtil.getAutoPublishObjs(projectObjs);
        if (autoPublishObj.length == 0) {
            DynamicObject bidPublishObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_bidpublish");
            autoPublishObj = new DynamicObject[]{bidPublishObj};
        }
        DynamicObject[] onlyCreateQuoObjs = SrcBidCompTplUtil.getOnlyCreateQuoObjs(autoPublishObj);
        SrcQuoteUtil.createQuoteBill(onlyCreateQuoObjs, bidChangeObjs);
        DynamicObject[] onlyCreateTenderObjs = SrcBidCompTplUtil.getOnlyCreateTenderObjs(autoPublishObj);
        SrcTenderUtil.createTenderBill(onlyCreateTenderObjs, true, bidChangeObjs);
        DynamicObject[] allCreateObjs = SrcBidCompTplUtil.getAllCreateObjs(autoPublishObj);
        if (allCreateObjs.length > 0) {
            SrcQuoteUtil.createQuoteBill(allCreateObjs, bidChangeObjs);
            SrcTenderUtil.createTenderBill(allCreateObjs, false, bidChangeObjs);
        }
        FeeManageUtils.createPaymentEntry((long)projectId);
        String message = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"SrcBidReplenishPublishService_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    public void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

