/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;
import kd.scm.src.common.util.SrcSchemeChgUtils;

public class SrcBidSchemeChgUpdateScheme
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        String message = ResManager.loadKDString((String)"\u65b9\u6848\u6216\u8bc4\u59d4\u66f4\u65b0\u5931\u8d25\u3002", (String)"SrcBidSchemeChgUpdateScheme_0", (String)"scm-src-common", (Object[])new Object[0]);
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)bidChangeObj.getDynamicObject("project"));
        DynamicObject newBidSchemeObj = TemplateUtil.getCompData((DynamicObject)bidChangeObj, (String)"src_bidschemechg");
        if (null == newBidSchemeObj) {
            result.setSuccess(false);
            this.handleLog(handleEvent, message);
            return result;
        }
        Object templateObj = bidChangeObj.get("template");
        String templateNumber = SrcSchemeChgUtils.getTemplateNumber(templateObj);
        DynamicObjectCollection newBidSchemeRows = newBidSchemeObj.getDynamicObjectCollection("entryentity");
        Map<Long, DynamicObject> newBidSchemeMap = newBidSchemeRows.stream().collect(Collectors.toMap(obj -> Optional.ofNullable(obj.getString("srcentryid")).map(Long::parseLong).orElse(0L), obj -> obj));
        String configF7 = null;
        if ("SYS099".equals(templateNumber)) {
            configF7 = "src_aptitudeconfigf7";
        }
        if ("SYS100".equals(templateNumber)) {
            configF7 = "src_aptitudeconfig2f7";
        }
        if ("SYS101".equals(templateNumber)) {
            configF7 = "src_bidopenconfig";
        }
        SrcSchemeChgUtils.updateConfigScheme(configF7, projectId, newBidSchemeMap);
        SrcSchemeChgUtils.updateConfigScorer(configF7, projectId, newBidSchemeMap);
        result.setSuccess(true);
        message = ResManager.loadKDString((String)"\u65b9\u6848\u6216\u8bc4\u59d4\u66f4\u65b0\u6210\u529f\u3002", (String)"SrcBidSchemeChgUpdateScheme_3", (String)"scm-src-common", (Object[])new Object[0]);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    public void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

