/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class SrcMaterialChgHandleService2
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)bidChangeObj.getDynamicObject("project"));
        DynamicObject newMaterialObj = TemplateUtil.getComponentData((String)bidChangeObj.getString("id"), (String)"src_materialchg");
        if (null == newMaterialObj) {
            return result;
        }
        DynamicObjectCollection newMaterialRows = newMaterialObj.getDynamicObjectCollection("entryentity");
        List<DynamicObject> newMaterialList = newMaterialRows.stream().filter(e -> e.getBoolean("ischanged") && e.getLong("srcentryid.id") == 0L).collect(Collectors.toList());
        if (newMaterialList == null || newMaterialList.size() == 0) {
            return result;
        }
        this.createOriginalPurlist(newMaterialList, projectId);
        String message = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"SrcMaterialChgHandleService2_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        return result;
    }

    public void createOriginalPurlist(List<DynamicObject> newMaterialList, long projectId) {
        DynamicObject[] purlistObjs = this.getPurlistObjs(projectId);
        Set<Long> materialIdSet = this.getMaterialIdSet(purlistObjs);
        Set<String> excludedFields = this.getExcludedFields();
        List properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)purlistObjs[0]);
        int index = PdsCommonUtils.object2Integer((Object)((DynamicObject)Arrays.asList(purlistObjs).stream().max((e1, e2) -> e1.getInt("purlistseq") - e2.getInt("purlistseq")).get()).get("purlistseq")) + 1;
        ArrayList<DynamicObject> newPurlisObjs = new ArrayList<DynamicObject>(newMaterialList.size());
        for (DynamicObject row : newMaterialList) {
            long materialId = row.getLong("material.id");
            if (materialId != 0L && !materialIdSet.add(materialId)) continue;
            DynamicObject newPurlistObj = BusinessDataServiceHelper.newDynamicObject((String)"src_purlistf7_save");
            PdsCommonUtils.setPrimaryKey((DynamicObject)newPurlistObj);
            PdsCommonUtils.copyDynamicObjectValue((DynamicObject)purlistObjs[0], (DynamicObject)newPurlistObj, (List)properties, excludedFields, (int)-1);
            PdsCommonUtils.copyDynamicObjectValue((DynamicObject)row, (DynamicObject)newPurlistObj, (List)properties, excludedFields, (int)-1);
            this.setSpecialValue(newPurlistObj, row.getDynamicObject("material"));
            newPurlistObj.set("purlistseq", (Object)index++);
            newPurlisObjs.add(newPurlistObj);
        }
        if (newPurlisObjs.size() > 0) {
            PdsCommonUtils.saveDynamicObjects(newPurlisObjs);
        }
    }

    public void setSpecialValue(DynamicObject newPurlistObj, DynamicObject materailObj) {
        newPurlistObj.set("purlist", newPurlistObj.getPkValue());
        newPurlistObj.set("billtype", (Object)"1");
    }

    public Set<String> getExcludedFields() {
        HashSet<String> excludedFields = new HashSet<String>(8);
        excludedFields.add("fseq");
        excludedFields.add("seq");
        excludedFields.add("purlistseq");
        excludedFields.add("entryid");
        excludedFields.add("purlist");
        excludedFields.add("srcentryid");
        excludedFields.add("isnew");
        excludedFields.add("supplier1");
        excludedFields.add("billtype");
        excludedFields.add("ischanged");
        excludedFields.add("sourcebillid");
        excludedFields.add("srcbillno");
        excludedFields.add("reqsource");
        excludedFields.add("sourceentryid");
        excludedFields.add("srcentryid");
        return excludedFields;
    }

    public DynamicObject[] getPurlistObjs(long projectId) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("billtype", "=", (Object)"1");
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_purlistf7", (boolean)false);
        return BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])qfilter.toArray());
    }

    public Set<Long> getMaterialIdSet(DynamicObject[] rows) {
        return Arrays.asList(rows).stream().map(e -> e.getLong("material.id")).collect(Collectors.toSet());
    }
}

