/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.change.SrcProjectCopyHandler;

public class SrcMaterialEndProjectCreator
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        DynamicObject endChgObj = TemplateUtil.getComponentData((String)bidChangeObj.getString("id"), (String)"src_materialend");
        DynamicObjectCollection chgEntryRows = endChgObj.getDynamicObjectCollection("entryentity");
        Map<Long, List<DynamicObject>> srcFlowEntryMap = this.getSrcFlowEntryMap(chgEntryRows);
        if (null == srcFlowEntryMap || srcFlowEntryMap.size() == 0) {
            return result;
        }
        for (Map.Entry<Long, List<DynamicObject>> entry : srcFlowEntryMap.entrySet()) {
            DynamicObject projectObj = this.createProject(bidChangeObj, entry.getKey(), entry.getValue());
            if (null == projectObj) continue;
            this.writeBackProject(chgEntryRows, entry.getValue(), SrmCommonUtil.getPkValue((DynamicObject)projectObj));
            this.createPurlist(projectObj, entry.getValue());
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject)endChgObj);
        String message = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"SrcMaterialEndProjectCreator_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        return result;
    }

    protected DynamicObject createProject(DynamicObject bidChangeObj, long srctypeId, List<DynamicObject> rows) {
        String sourceType = rows.get(0).getString("srctype.sourcetype.number");
        ExtPluginContext context = new ExtPluginContext();
        context.setBillObj(bidChangeObj);
        context.getParamMap().put("sourcetype", sourceType);
        context.getParamMap().put("srctype", srctypeId);
        context.getParamMap().put("bidname", rows.get(0).getString("bidname"));
        context.getParamMap().put("billno", "");
        context.getParamMap().put("issource", "");
        context.getParamMap().put("version", "");
        ExtPluginFactory.executeExtplugin((String)SrcProjectCopyHandler.class.getSimpleName(), (ExtPluginContext)context, (boolean)true, (String)SrcProjectCopyHandler.class.getName());
        return context.getProjectObj();
    }

    protected void writeBackProject(DynamicObjectCollection endChgRows, List<DynamicObject> rows, long projectId) {
        for (DynamicObject endChgRow : endChgRows) {
            for (DynamicObject row : rows) {
                if (endChgRow.getLong("id") != row.getLong("id")) continue;
                endChgRow.set("project", (Object)projectId);
            }
        }
    }

    protected void createPurlist(DynamicObject projectObj, List<DynamicObject> srcflowRows) {
        HashSet<String> excludedFields = new HashSet<String>(8);
        excludedFields.add("project");
        excludedFields.add("package");
        excludedFields.add("purlist");
        excludedFields.add("entrystatus");
        excludedFields.add("parentid");
        excludedFields.add("purlistentry_supfj");
        ArrayList<DynamicObject> newBillList = new ArrayList<DynamicObject>(4);
        Map<Long, List<DynamicObject>> purlistMap = srcflowRows.stream().collect(Collectors.groupingBy(e -> e.getLong("purlist.billid")));
        for (Map.Entry<Long, List<DynamicObject>> entry : purlistMap.entrySet()) {
            DynamicObject previousBillObj;
            String compkey = entry.getValue().get(0).getString("purlist.compkey.number");
            if (StringUtils.isBlank((CharSequence)compkey) || null == (previousBillObj = this.getPreviousBillObj(entry.getKey(), compkey))) continue;
            DynamicObject newBillObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)previousBillObj, (boolean)true, (boolean)true);
            PdsCommonUtils.setPrimaryKey((DynamicObject)newBillObj);
            newBillObj.set("parentid", (Object)projectObj.getLong("id"));
            DynamicObjectCollection newEntryObjs = newBillObj.getDynamicObjectCollection("entryentity");
            if (newEntryObjs.size() == 0) continue;
            List properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)((DynamicObject)newEntryObjs.get(0)));
            newEntryObjs.clear();
            newBillList.add(newBillObj);
            Map<Long, DynamicObject> previousEntryMap = this.getPreviousEntryMap(previousBillObj);
            if (null == previousEntryMap || previousEntryMap.size() == 0) continue;
            int seq = 1;
            for (DynamicObject row : entry.getValue()) {
                long entryId = row.getLong("purlist.id");
                DynamicObject previousEntryObj = previousEntryMap.get(entryId);
                if (null == previousEntryObj) continue;
                DynamicObject newEntryObj = newEntryObjs.addNew();
                PdsCommonUtils.setPrimaryKey((DynamicObject)newEntryObj);
                PdsCommonUtils.copyDynamicObjectValue((DynamicObject)previousEntryObj, (DynamicObject)newEntryObj, (List)properties, excludedFields, (int)seq++);
                newEntryObj.set("purlist", newEntryObj.getPkValue());
                newEntryObj.set("project", projectObj.getPkValue());
                newEntryObj.set("entrystatus", (Object)ProjectStatusEnums.TOQUOTE.getValue());
                newEntryObj.set("qty", row.get("qty"));
                newEntryObj.set("purlistentry_fj", (Object)PdsCommonUtils.cloneAttachment((DynamicObject)previousEntryObj, (String)"purlistentry_fj"));
            }
        }
        PdsCommonUtils.saveDynamicObjects(newBillList);
    }

    private Map<Long, List<DynamicObject>> getSrcFlowEntryMap(DynamicObjectCollection chgEntryRows) {
        Map<Long, List<DynamicObject>> chgEntryMap = chgEntryRows.stream().filter(e -> e.getBoolean("issource")).collect(Collectors.groupingBy(e -> e.getLong("srctype.id")));
        return chgEntryMap;
    }

    private DynamicObject getPreviousBillObj(long billId, String compkey) {
        if (QueryServiceHelper.exists((String)compkey, (Object)billId)) {
            return BusinessDataServiceHelper.loadSingle((Object)billId, (String)compkey);
        }
        return null;
    }

    private Map<Long, DynamicObject> getPreviousEntryMap(DynamicObject previousBillObj) {
        DynamicObjectCollection rows = previousBillObj.getDynamicObjectCollection("entryentity");
        if (rows.size() == 0) {
            return Collections.emptyMap();
        }
        Map<Long, DynamicObject> previousEntryMap = rows.stream().collect(Collectors.groupingBy(e -> e.getLong("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        return previousEntryMap;
    }
}

