/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.IDataValidateService;
import kd.scm.pds.common.change.ValidateEvent;
import kd.scm.pds.common.change.ValidateResult;
import kd.scm.pds.common.util.PdsPurlistUtils;
import kd.scm.src.common.contract.SrcContractUtils;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcMaterialEndPushValidator
implements IDataValidateService {
    private static final long serialVersionUID = 1L;

    public ValidateResult validate(ValidateEvent validateEvent) {
        ValidateResult result = SrcBidChangeUtil.commonValidate(validateEvent, "src_materialend");
        if (!result.isSuccess()) {
            return result;
        }
        DynamicObjectCollection rows = result.getChgCompObj().getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            result.setMessage(ResManager.loadKDString((String)"\u6807\u7684\u6d41\u6807\u53d8\u66f4\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcMaterialEndPushValidator_0", (String)"scm-src-common", (Object[])new Object[0]));
            result.setSuccess(false);
            return result;
        }
        this.isAllPurlistEnd(rows, result);
        if (!result.isSuccess()) {
            return result;
        }
        Map resultMap = SrmCommonUtil.isRepeatForEntry((DynamicObjectCollection)rows, (String)"supplier", (String)"purlist", null);
        if (!((Boolean)resultMap.get("succed")).booleanValue()) {
            result.setMessage(resultMap.get("message").toString());
            result.setSuccess(false);
            return result;
        }
        String message = SrcContractUtils.contractHasPush(result.getProjectObj());
        if (null != message) {
            result.setMessage(message);
            result.setSuccess(false);
            return result;
        }
        this.isSelectSourceType(rows, result);
        return result;
    }

    private ValidateResult isSelectSourceType(DynamicObjectCollection rows, ValidateResult result) {
        List sourceTypeList = rows.stream().filter(e -> e.getString("issource").equals("true")).filter(e -> Objects.isNull(e.getString("srctype"))).collect(Collectors.toList());
        if (sourceTypeList.size() == 0) {
            return result;
        }
        Set materialIdSet = sourceTypeList.stream().map(e -> e.getInt("seq")).collect(Collectors.toSet());
        String indexStr = materialIdSet.stream().map(String::valueOf).collect(Collectors.joining(","));
        result.setMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u6807\u7684\u5f00\u542f\u4e86\u201c\u662f\u5426\u91cd\u65b0\u5bfb\u6e90\u201d\u6309\u94ae\uff0c\u5bfb\u6e90\u6d41\u7a0b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SrcMaterialEndPushValidator_1", (String)"scm-src-common", (Object[])new Object[0]), indexStr));
        result.setSuccess(false);
        return result;
    }

    public ValidateResult isAllPurlistEnd(DynamicObjectCollection rows, ValidateResult result) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)result.getProjectObj());
        Set purListEndIds = PdsPurlistUtils.getPurilstEndIds((long)projectId);
        QFilter purlistFilter = new QFilter("project", "=", (Object)projectId);
        purlistFilter.and("billtype", "=", (Object)"1");
        DynamicObjectCollection purlistRows = QueryServiceHelper.query((String)"src_purlistf7", (String)"id", (QFilter[])purlistFilter.toArray());
        Set purListIds = purlistRows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        if (purListEndIds.size() >= purListIds.size()) {
            result.setMessage(ResManager.loadKDString((String)"\u672c\u9879\u76ee\u6240\u6709\u6807\u7684\u5747\u8981\u88ab\u6d41\u6807\uff0c\u53ef\u80fd\u5bfc\u81f4\u6d41\u7a0b\u65e0\u6cd5\u6267\u884c\uff0c\u8bf7\u7528 \u9879\u76ee\u7ec8\u6b62/\u5e9f\u6807 \u8fdb\u884c\u53d8\u66f4\u3002", (String)"SrcMaterialEndPushValidator_2", (String)"scm-src-common", (Object[])new Object[0]));
            result.setSuccess(false);
        }
        return result;
    }
}

