/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class SrcMaterialEndQuoteTerminator
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        Set<Long> purlistIds = this.getPurlistIds(bidChangeObj, false);
        if (null != purlistIds && purlistIds.size() > 0) {
            QFilter qfilter = this.getQFilter(bidChangeObj, purlistIds, false);
            this.updatePurlistStatus("src_purlistf7", qfilter, null);
            this.updatePurlistStatus("src_contractentry", qfilter, null);
        }
        if (null != (purlistIds = this.getPurlistIds(bidChangeObj, true)) && purlistIds.size() > 0) {
            Set<String> supplierIds = this.getSupplierIds(bidChangeObj);
            QFilter qfilter = this.getQFilter(bidChangeObj, purlistIds, true);
            this.updatePurlistStatus("src_purlistf7", qfilter, supplierIds);
            this.updatePurlistStatus("src_contractentry", qfilter, supplierIds);
        }
        String message = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"SrcMaterialEndQuoteTerminator_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        return result;
    }

    private void updatePurlistStatus(String entityName, QFilter qfilter, Set<String> supplierIds) {
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)entityName, (String)"purlist,supplier,entrystatus,entrystatus2", (QFilter[])qfilter.toArray());
        if (rows.length == 0) {
            return;
        }
        boolean isEntrystatus2 = "src_purlistf7".equals(entityName);
        ArrayList<DynamicObject> rowList = new ArrayList<DynamicObject>(rows.length);
        if (null == supplierIds || supplierIds.size() == 0) {
            for (DynamicObject row : rows) {
                this.updateStatus(row, rowList, isEntrystatus2);
            }
        } else {
            for (DynamicObject row : rows) {
                if (!this.isNeedChange(row, supplierIds)) continue;
                this.updateStatus(row, rowList, isEntrystatus2);
            }
        }
        PdsCommonUtils.saveDynamicObjects(rowList);
    }

    public void updateStatus(DynamicObject row, List<DynamicObject> rowList, boolean isEntrystatus2) {
        row.set("entrystatus", (Object)ProjectStatusEnums.INVALID.getValue());
        if (isEntrystatus2) {
            row.set("entrystatus2", (Object)ProjectStatusEnums.TERMINATED.getValue());
        }
        rowList.add(row);
    }

    private boolean isNeedChange(DynamicObject row, Set<String> supplierIds) {
        String key = row.getString("id") + '_' + row.getString("supplier.id");
        return supplierIds.contains(key);
    }

    private Set<Long> getPurlistIds(DynamicObject bidChangeObj, boolean isBySupplier) {
        DynamicObject materialChgObj = TemplateUtil.getComponentData((String)bidChangeObj.getString("id"), (String)"src_materialend");
        if (null == materialChgObj) {
            return null;
        }
        DynamicObjectCollection rows = materialChgObj.getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            return null;
        }
        if (isBySupplier) {
            return rows.stream().filter(e -> e.getLong("supplier.id") > 0L).map(e -> e.getLong("purlist.id")).collect(Collectors.toSet());
        }
        return rows.stream().filter(e -> e.getLong("supplier.id") == 0L).map(e -> e.getLong("purlist.purlist.id")).collect(Collectors.toSet());
    }

    private Set<String> getSupplierIds(DynamicObject bidChangeObj) {
        DynamicObject materialChgObj = TemplateUtil.getComponentData((String)bidChangeObj.getString("id"), (String)"src_materialend");
        DynamicObjectCollection rows = materialChgObj.getDynamicObjectCollection("entryentity");
        Set<String> supplierIds = rows.stream().filter(e -> e.getLong("supplier.id") > 0L).map(e -> e.getString("purlist.id") + '_' + e.getString("supplier.id")).collect(Collectors.toSet());
        return supplierIds;
    }

    private QFilter getQFilter(DynamicObject bidChangeObj, Set<Long> purlistIds, boolean isBySupplier) {
        HashSet<String> statusSet = new HashSet<String>(4);
        statusSet.add(ProjectStatusEnums.TOQUOTE.getValue());
        statusSet.add(ProjectStatusEnums.QUOTED.getValue());
        statusSet.add(ProjectStatusEnums.OPENED.getValue());
        statusSet.add(ProjectStatusEnums.CLOSED.getValue());
        statusSet.add(ProjectStatusEnums.DECIDED.getValue());
        statusSet.add(ProjectStatusEnums.SIGNED.getValue());
        QFilter qfilter = null;
        qfilter = isBySupplier ? new QFilter("id", "in", purlistIds) : new QFilter("purlist", "in", purlistIds);
        qfilter.and("entrystatus", "in", statusSet);
        qfilter.and("supplier", ">", (Object)0);
        return qfilter;
    }
}

